package com.engine;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.engine.core.Core;
import com.engine.layer.Layer;

public class LevelLoad extends Layer
{
	static String path = null;
	
	static public void setPath(final String path)
	{
		LevelLoad.path = path;
	}
	
	public LevelLoad()
	{
		path = null;
	}
	
	public LevelLoad(String fileName)
	{
		try {
			loadLevel(fileName);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public LevelLoad(final InputStream stream)
	{
		try {
			loadLevelFromStream(stream);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void loadLevel(String fileName) throws IOException
	{
		loadLevelFromStream(Core.getInstance().getContext().getAssets().open(path+"/"+fileName));
	}
	
	int Get32(InputStream s) throws IOException
	{
		return Get32(s.read(), s.read(), s.read(), s.read());
	}
	
	int Get32(int a, int b, int c, int d)
	{
		return b << 24 | c << 16 | d << 8 | a;
	}
	
	int Get16(InputStream s) throws IOException
	{
		return Get16(s.read(), s.read());
	}
	
	int Get16(int a, int b)
	{
		return b << 8 | a;
	}
	
	int Get8(InputStream s) throws IOException
	{
		return Get8(s.read());
	}
	
	int Get8(int a)
	{
		return a;
	}
	
	public void loadLevelFromStream(final InputStream stream) throws IOException
	{
		DataInputStream input = new DataInputStream(stream);
		//stream.read();
		int count = Get16(input);
		//Debug.err("LEVEL: count ", ""+count);
		for(int i = 0; i<count; i++)
		{
			int id = Get8(input)+1;
			int x = Get16(input);
			int y = Get16(input);
			//Debug.err("LEVEL: id ", ""+id+", x "+x+", y "+y);
			Background temp = Background.create(id, x, y);
			addBackground(temp);
		}
	}
}
