package com.mbs.EngineTest;

import android.graphics.Paint.Align;
import android.view.MotionEvent;

import com.engine.RandomUtils;
import com.engine.ShowFPS;
import com.engine.Sprite;
import com.engine.core.Core;
import com.engine.core.GameInterface;
import com.engine.core.Graphics;
import com.engine.layer.Layer;
import com.engine.object.Object;
import com.engine.resource.Resource;

public class Game extends GameInterface
{
	public Layer manager = null;
	SpriteFactory sprite_factory;
	
	class Chmury extends Object
	{
		@Override
		public void onCreate()
		{
			sprite_index = SpriteFactory.CHMURY;
			image_index = RandomUtils.random.nextInt(3);
			image_speed = 0;
			y = RandomUtils.random.nextInt(Core.getInstance().getGraphics().getHeight());
			x = Core.getInstance().getGraphics().getWidth()+Sprite.getWidth(sprite_index)/2;
			super.onCreate();
		}
		
		// akcje wykonywane co klatk
		@Override
		public void onStep()
		{
			x--;
			if(x<-Sprite.getWidth(sprite_index))
				instanceDestroy();
			super.onStep();
		}
	}
	
	public static class SpriteFactory extends Resource
	{
		public static int CHMURY;
		public static int TLO;
		
		@Override
		public void onInit()
		{
			CHMURY = loadSprite("chmury.png", 3);
			TLO = loadSprite("background.png");
		}
		
		@Override
		public void endLoad()
		{
			Sprite.list[CHMURY].setOriginCenter();
		}
	}
	@Override
	public int onCreate()
	{
		sprite_factory = new SpriteFactory();
		// aduje wszystkie sprajty do pamici
		sprite_factory.onLoadAll();
		
		//tworzy warstw gry
		manager = new Layer()
		{
			// akcje wykonywane przy starcie
			public void onCreate()
			{
				alarm[0] = 1;
				for(int i = 0; i<4; i++)
				{
					Chmury clow = new Chmury()
					{
						@Override
						public void onCreate()
						{
							super.onCreate();
							x = -50+RandomUtils.random.nextInt(Core.getInstance().getGraphics().getWidth()+50);
							y = RandomUtils.random.nextInt(Core.getInstance().getGraphics().getHeight());
						}
					};
					addObject(clow);
				}
				super.onCreate();
			}
			// akcja wykonywana po okrelonej iloci klatek ustawianych w alarm[...]
			@Override
			public void alarm0()
			{
				alarm[0] = 90;
				Chmury clow = new Chmury();
				addObject(clow);
				clow.onCreate();
			}
			
			// rysuje wszystko w tej warstwie
			public void onDraw(Graphics g)
			{
				Sprite.draw(g, SpriteFactory.TLO, 0, 0, 0);
				super.onDraw(g);
				g.getPaint().setTextAlign(Align.CENTER);
				g.setTextSize(32);
				g.getPaint().setAntiAlias(true);
				g.drawText("Test Silnika 2D", g.getWidth()/2, g.getHeight()/2);
				new ShowFPS().onDraw(g);
				g.getPaint().setAntiAlias(false);
			}
		};
		manager.onCreate();
		return 0;
	}
	
	@Override
	public int onDraw()
	{
		manager.onStep();
		manager.onDraw(Core.getInstance().getGraphics());
		return 0;
	}
	
	@Override
	public boolean onTouchEvent(MotionEvent event)
	{
		int x = (int)event.getX();
		int y = (int)event.getY();
		if(event.getAction() == MotionEvent.ACTION_DOWN)
		{
			if(manager.onTouchDown(x, y))
				return true;
		}
		if(event.getAction() == MotionEvent.ACTION_UP)
		{
			if(manager.onTouchUp(x, y))
				return true;
		}
		return super.onTouchEvent(event);
		
	}
}
