package com.engine.object;

public class ObjectTimer extends Object
{
	public final static int TIMER_COUNT = 3;
	
	protected long timer[];
	
	protected long tstart[];
	
	protected ObjectTimer()
	{
		timer = new long[TIMER_COUNT];
		tstart = new long[TIMER_COUNT];
		for(int i = 0; i<TIMER_COUNT; i++)
		{
			timer[i] = -1;
			tstart[i] = System.currentTimeMillis();
		}
	}
	
	public void setTime(int id, long time)
	{
		assert id>TIMER_COUNT;
		timer[id] = time;
		tstart[id] = System.currentTimeMillis();
	}
	
	public void clearTime()
	{
		for(int i = 0; i<TIMER_COUNT; i++)
		{
			timer[i] = -1;
		}
	}
	
	@Override
	public void onStep()
	{
		long temp = System.currentTimeMillis();
		for(int i = 0; i<TIMER_COUNT; i++)
		{
			if(timer[i] != -1)
			{
				if(temp-tstart[i]>=timer[i])
				{
					timer[i] = -1;
					switch(i)
					{
						case 0:
							onAction0();
							break;
						case 1:
							onAction1();
							break;
						case 2:
							onAction2();
							break;
					}
				}
			}
		}
		super.onStep();
	}
	
	public void onAction0()
	{
	}
	
	public void onAction1()
	{
	}
	
	public void onAction2()
	{
	}
}
