package com.engine.core;

public class StateCode
{
    /** Set of state status codes. */
    public static final int TERMINATED = 0;

    public static final int INITIALIZED = 1;

    public static final int RUNNING = 2;

    public static final int STOPPED = 3;

    public static final int PAUSED = 4;

    public static String toString(int code)
    {
        String codeString;

        switch (code)
        {
            case TERMINATED:
                codeString = "TERMINATED";
                break;

            case INITIALIZED:
                codeString = "INITIALIZED";
                break;

            case RUNNING:
                codeString = "RUNNING";
                break;

            case STOPPED:
                codeString = "STOPPED";
                break;

            case PAUSED:
                codeString = "PAUSED";
                break;

            default:
                codeString = "UKNOWN";
                break;
        }

        return codeString;
    }
}
