using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


//Bdziemy korzysta z bibliotek .NET do obsugi poczty elektronicznej
using System.Net.Mail;


namespace mailer
{
    public partial class FormaProgramu : Form
    {

        // Cz konfiguracyjna
        private string adresOd  = "adres_wysylajacego@gmail.com";
        private string adresDo  = "adres_odbierajacego@gmail.com";
        private string temat    = "Mailer - program na zaliczenie";
        private string smtpHost = "smtp.gmail.com";
        private int    smtpPort = 465;
        private bool   smtpSSL  = true;


        public FormaProgramu()
        {
            InitializeComponent();
        }

        private void ButtonWyslij_Click( object sender, EventArgs e )
        {
            //Sprawdzamy czy pole Imi puste
            if ( TextBoxImie.Text == "" )
            {
                MessageBox.Show( "Pole Imi jest puste! Prosz wpisa dane." );
                return;
            }

            // Sprawdzamy czy pole Nazwisko jest puste
            if ( TextBoxNazwisko.Text == "" )
            {
                MessageBox.Show( "Pole Nazwisko jest puste! Prosz wpisa dane." );
                return;
            }

            //Sprawdzamy czy jedna z pci jest zaznaczona
            if ( RadioKobieta.Checked == false && RadioMezczyzna.Checked == false )
            {
                MessageBox.Show( "Pe nie zostaa okrelona! Wybierz odpowiedni opcj." );
                return;
            }


            // Wszystkie dane s wpisane. Czas wysa maila.
            string plec = ( RadioKobieta.Checked == true ) ? "Kobieta" : "Mczyzna";

            // Tworzymy typ MailMessage
            MailMessage mail    = new MailMessage( adresOd, adresDo, temat, "Imi: "+TextBoxImie.Text+"\nNazwisko: "+TextBoxNazwisko.Text+"\nPe: "+plec );

            //Wedlug referencji na msdn.com dodajemy pola, ktre pozwol na autentyfikacj konta
            mail.Headers.Add( "smtpauthenticate", "1" );
            mail.Headers.Add( "sendusername","tutaj_login" );
            mail.Headers.Add( "sendpassword","tutaj_haslo" );
           
     
            //Tworzymy klienta SMTP i wysylamy maila
            SmtpClient klient   = new SmtpClient();

            klient.Host         = smtpHost;
            klient.Port         = smtpPort;
            klient.EnableSsl    = smtpSSL;

            //Przechwycmy blad wysylania
            try
            {
                klient.Send( mail );
                MessageBox.Show( "Wysano maila!" );
            }
            catch ( SmtpException blad )
            {
                MessageBox.Show( "Bd wysania maila: " + blad.Message );
            }
        }

        private void ButtonResetuj_Click( object sender, EventArgs e )
        {
            //Resetujemy dane
            TextBoxImie.Text        = "";
            TextBoxNazwisko.Text    = "";
            RadioKobieta.Checked    = false;
            RadioMezczyzna.Checked  = false;
        }
    }
}