
#define sock_connect
/*sock_connect
  call to connect to a remote host.
  first arg: string w/ an IP address
  second arg: real w/ a port number
  third arg: 0 = blocking, 1 = asynchronous. 
  returns: a real that is a socket discriptor, or a negative error code for an error  NOTE:
  blocking means that if there is nothing in the buffer at the time that sock_receive is called, 
  it will hang the game till there is data. asynchronous means that if there is nothing in the buffer,
  sock_receive will not hang, and instead will return an empty string. Most likely you will want to chose 
  asynchronous, and check it every step
*/
var tmp;
tmp = external_call(global._GMSOCK_CON,argument0,argument1,argument2);
if (tmp != -1) {
   ds_map_add(global._GMSOCK_BUFFER,string(tmp)+"|",0);
   ds_map_add(global._GMSOCK_BUFFER,string(tmp),"");
}    
return tmp;


#define sock_disconnect
/* sock_disconnect
   call to close a socket connection.
   first arg: the real socket identifier return by sock_connect
   returns: 1
*/
ds_map_delete(global._GMSOCK_BUFFER,string(argument0));
ds_map_delete(global._GMSOCK_BUFFER,string(argument0)+"|");
ds_map_delete(global._GMSOCK_BUFFER,string(argument0)+"&");
return external_call(global._GMSOCK_CLO,argument0);


#define sock_bind
/*sock_bind
prepares a socket for accepting connections(e.g. the server side of the game)
first arg: the port number to listen on
second arg: the max number of connections that can be trying to connect before 
you call sock_accept.
returns: a socket identifier for use w/ sock_accept. DO NOT try to read or write
to it. if an error, returns a negative error code
*/
return external_call(global._GMSOCK_BND,argument0,argument1);


#define sock_accept
/*sock_accept
if there is somebody trying to connect to a socket created w/ sock_bind,
this function will return a new socket identifier that is connected to that
person. You can continue to use the first socket to get more people to connect,
or you can close it if you only want one person.
first arg:  the socket identifier returned by sock_bind. DO NOT use one returned by 
            sock_connect
second arg: 1 if the NEW socket should be asynchrounous, 0 if not 
returns:    a new socket identifier if somebody is trying to connect the the one created by sock_bind.
            If there is nobody trying to connect, it WILL NOT hang the program. instead, it returns a -1
*/
var tmp;
tmp = external_call(global._GMSOCK_ACP,argument0,argument1);
if (tmp != -1) {
   ds_map_add(global._GMSOCK_BUFFER,string(tmp)+"|",0);
   ds_map_add(global._GMSOCK_BUFFER,string(tmp),"");
}  
sock_setasync(tmp,argument1);
return tmp;


#define sock_send
/* sock_send
   sends a string across a socket
   first arg: the real socket identifier returned by sock_connect or sock_accept
   second arg: the string that should be sent
   returns: the number of characters sent
*/
var tmp;
tmp =  external_call(global._GMSOCK_SND,argument0,argument1);
if (tmp < 0) {
   show_debug_message("Send error code: " + string(tmp));
};


#define sock_receive
/* sock_receive
    receives a single character from the socket
    
    first arg: the socket identifier returned by sock_connect or sock_accept
    returns: the string read from the socket. An empty string is returned if the server disconnected or for an
            invalid socket
    NOTE:   if the server sends over 30,000 characters before the program reads them all, the receive buffer will overflow.
            If for some reason you need more than 30,000 characters, PM me and I will compile a special version for you.
*/
var buffer,pos;
if (argument0 == -1)
   return "";
buffer = ds_map_find_value(global._GMSOCK_BUFFER,string(argument0));
pos = ds_map_find_value(global._GMSOCK_BUFFER,string(argument0)+"|");
if (pos >= string_length(buffer)) {   // if the buffer is all used up
   pos = 1;                 // reset the position
   buffer = sock_receive_nobuff(argument0); // and update the buffer
   if (buffer == "")
      pos = 0;
   ds_map_replace(global._GMSOCK_BUFFER,string(argument0),buffer);
   ds_map_replace(global._GMSOCK_BUFFER,string(argument0)+"|",pos);
} else { // if there's another char in the buffer advance the counter
   pos += 1;
   ds_map_replace(global._GMSOCK_BUFFER,string(argument0)+"|",pos);
}
return string_char_at(buffer,pos);


#define sock_lookup
/* sock_lookup
   performs a DNS lookup on a hostname
   first arg: the hostname to look up
   returns: the IP address of the hostname, or an empty string if it couldn't be found
   NOTE: a hostname is the url without the www:
   e.g: to look up www.yahoo.com
   do sock_lookup("yahoo.com");
   */
return external_call(global._GMSOCK_LOK,argument0);


#define sock_init
/*sock_init:
  call before using any of the sock_ or udp_ functions
  returns 1 if the DLL is ready for use
  return 0 if not.
  NOTE: if it returns 0, than there is a WSA error.
*/
global._GMSOCK_CON = external_define("GMsock.dll","GMconnect",dll_cdecl,ty_real,3,ty_string,ty_real,ty_real);
global._GMSOCK_SND = external_define("GMsock.dll","GMsend",dll_cdecl,ty_real,2,ty_real,ty_string);
global._GMSOCK_REC = external_define("GMsock.dll","GMrecieve",dll_cdecl,ty_string,1,ty_real);
global._GMSOCK_CLO = external_define("GMsock.dll","GMclose",dll_cdecl,ty_real,1,ty_real);
global._GMSOCK_LOK = external_define("GMsock.dll","GMlookup",dll_cdecl,ty_string,1,ty_string);
global._GMSOCK_BND = external_define("GMsock.dll","GMbind",dll_cdecl,ty_real,2,ty_real,ty_real);
global._GMSOCK_ACP = external_define("GMsock.dll","GMaccept",dll_cdecl,ty_real,2,ty_real,ty_real);
global._GMSOCK_WSA_STA = external_define("GMsock.dll","GMwsaStart",dll_cdecl,ty_real,0);
global._GMSOCK_WSA_STP = external_define("GMsock.dll","GMwsaStop",dll_cdecl,ty_real,0);
global._GMSOCK_GPN = external_define("GMsock.dll","GMgetpeer",dll_cdecl,ty_string,1,ty_real);
global._GMSOCK_GHN = external_define("GMsock.dll","GMgethost",dll_cdecl,ty_string,0);
global._GMSOCK_ASY = external_define("GMsock.dll","GMsetasync",dll_cdecl,ty_real,2,ty_real,ty_real);
global._GMSOCK_UCN = external_define("GMsock.dll","GMudpconnect",dll_cdecl,ty_real,2,ty_real,ty_real);
global._GMSOCK_USN = external_define("GMsock.dll","GMudpsend",dll_cdecl,ty_real,4,ty_real,ty_string,ty_real,ty_string);
global._GMSOCK_URC = external_define("GMsock.dll","GMudprecv",dll_cdecl,ty_string,1,ty_real);
global._GMSOCK_UIP = external_define("GMsock.dll","GMudpip",dll_cdecl,ty_string,0);
global._GMSOCK_GER = external_define("GMsock.dll","GMlasterror",dll_cdecl,ty_real,0);
global._GMSOCK_CER = external_define("GMsock.dll","GMclearerror",dll_cdecl,ty_real,0);
global._GMSOCK_MAC = external_define("GMsock.dll","GMMACaddr",dll_cdecl,ty_string,0);
global._GMSOCK_MESSAGE_ID = -1;
global._GMSOCK_MESSAGE_VALUE = "";
if (variable_global_exists("_GMSOCK_BUFFER"))
   ds_map_clear(global._GMSOCK_BUFFER);
else 
   global._GMSOCK_BUFFER = ds_map_create();
if (variable_global_exists("_GMSOCK_ITER"))
   ds_map_clear(global._GMSOCK_ITER);
else 
   global._GMSOCK_ITER = ds_map_create();
return external_call(global._GMSOCK_WSA_STA);


#define sock_deinit
/* sock_deinit
   should be called whenever the socket dll will not need to be used again.
   Should it need to be used, you must call sock_init again before anything else.
   returns: 1
*/
external_free("GMsock.dll");
return external_call(global._GMSOCK_WSA_STP);


#define sock_message_send
/*identical to mplay_message_send
first arg: socked identifier returned by sock_connect or sock_accept
second arg: a real message id between 0 & 255
third arg: a string message value
returns 1 if success, 0 if failure
*/
if (argument0 == -1)
   return 0;
if (sock_send(argument0,chr(argument1) + argument2 + chr(13)) > 0)
   return 1;
else
   return 0;


#define sock_message_receive
/*identical to mplay_message_receive
first arg:  socket identifier returned by sock_connect or sock_accept
returns:    1 if message received, 0 if not.
This reutine will hang if the socket is async and only part of a message, or data that is not a message is
received.
*/
if (argument0 == -1)
   return "";
var char;
char = sock_receive(argument0);
if (char == "")
   return 0;
global._GMSOCK_MESSAGE_ID = ord(char);
global._GMSOCK_MESSAGE_VALUE = sock_token_receive(argument0,chr(13));
return 1;


#define sock_message_id
/*identical to mplay_message_id()
returns:    the id of the last message received, or -1 if there is no message
*/
return global._GMSOCK_MESSAGE_ID;


#define sock_message_value
/*identical to mplay_message_value
returns:    the value of the last message or an empty string if none have been
            received.
*/
return global._GMSOCK_MESSAGE_VALUE;


#define sock_token_send
/* sends a token readible by sock_token_receive.
first arg:  the socket identifier returned by sock_connect or sock_accept
second arg: the data to be sent
third arg:  the token delimiter
returns:    1 for success, 0 for failure
*/
if (argument0 == -1)
   return 0;
return sock_send(real(argument0),string(argument1) + argument2);
   


#define sock_token_receive
/* reads a token from a socket. A token is all the data up to a specific delimiter
character.
first arg:  the socket identifier returned by sock_connect or sock_accept
second arg: the delimiter character.
return:     the token, NOT INCLUDING the delimiter character, or empty string if
            the socket is invalid. Also returns empty string if the socket is
            asynchronous and there are no characters to be received.
*/
if (argument0 < 0)
   exit;
var tmp,pos,curpos,ret;
curpos = ds_map_find_value(global._GMSOCK_BUFFER,string(argument0)+"|")+1; // get the current position
tmp = ds_map_find_value(global._GMSOCK_BUFFER,string(argument0));   // get the current buffer contents
do {
   pos = string_pos(argument1,tmp);   // find the token char in the buffer
   if (pos <= curpos) {                 // if we can't find it, or if it's already been read
      tmp = tmp+sock_receive_nobuff(argument0);      // get more data, and put it in the buffer
      if (tmp == "") 
         return "";
   }
} until (pos > curpos);  // keep going till we find the token char
ds_map_replace(global._GMSOCK_BUFFER,string(argument0)+"|",0);  // put the position at 0
ret = string_copy(tmp,curpos,pos-curpos);   // copy the string from the starting point to the token ender, not including the token
ds_map_replace(global._GMSOCK_BUFFER,string(argument0),string_delete(tmp,1,pos)); // delete everything in the buffer from the token deletemeter and back
return ret;


#define sock_receive_all
/*  sock_receive_all
    reads everything the server sends until it disconnects
    or if the socket is asynchronous, it will read everything the server has sent so far.
first arg:  the socket identifier returned by sock_connect or sock_accept
second arg: the maximum bytes to read.
returns:    everything read, or an empty string if the socket id is invalid
*/
if (argument0 < 0)
   return "";
var char,str,ctr;
str = "";
ctr = 0;
char = sock_receive(argument0,1);
while (char != "" && ctr < argument1) {
   str += char;
   ctr += 1;
   char = sock_receive(argument0,1);
}
return str;


#define sock_receive_nobuff
/*sock_receive_nobuff
Returns all the characters in the socket, without a buffer. This is a lot 
faster than sock_receive. However, do not EVER mix the 2. also, if this script
is called while the server is not finshed sending data, it WILL only give you
part of the data. Be carefull. If the socket is synchronus, and nothing is on
the socket, than this script WILL BLOCK.
first arg:  the socket id
returns:    empty string if the server disconnected, or if the socket is 
            asynchronous and the socket has nothing to read. Or the 
            characters read.
NOTE: In case you haven't guessed already, this script is dangourus. It is only
if you need the speed, and can coding a fallback incase only part of the data
is received.
*/
if (argument0 < 0)
   return "";
return external_call(global._GMSOCK_REC,argument0);


#define sock_gethostname
/*sock_gethostname
   returns the host name of the current computer, or an empty string if an error. 
   
   this function is a lot faster than mplay_ipaddress()
   you can call it every step
*/
return external_call(global._GMSOCK_GHN);


#define sock_setasync
/*sock_setasync
   let's u change a synchronous socket into an asynchronous one or vice-versa
   first arg: the socket id returned from sock_connect or sock_accept or sock_bind to opperate on
   second arg: 0 to make socket sync, 1 to make it async
   returns: a negative error code on an error, or 1
   
   NOTE: if you set a socket created with sock_bind to synchronous, the next call
   to sock_accept will hang untill a connection is received, instead of returning
   emediatly.
*/
if (argument0 < 0)
   return -1;
return external_call(global._GMSOCK_ASY,argument0,argument1);


#define sock_ip
/*sock_ip
  returns: ip address of the current machine
  
  NOTE: this function is a lot faster than mplay_ipaddress()
  you can call it every step.
*/
return sock_lookup(sock_gethostname());


#define sock_getpeerip
/*sock_getpeerip
   returns the ipaddress of the user on the other end of a socket
   first arg: the socket id returned by sock_connect or sock_accept
   returns: the ip address of the comp on the other end of the socket, or an empty string on error
*/
if (argument0 < 0)
   return "";
return external_call(global._GMSOCK_GPN,argument0);


#define sock_geterror
/* sock_geterror
   returns the most recent error code from the DLL
   Usefull for functions that return an empty string on an error instead of an error code
   sock_receive(),udp_receive(),sock_ip(),sock_lookup(),etc.
*/
var er;
er = external_call(global._GMSOCK_GER);
external_call(global._GMSOCK_CER);
return er;


#define sock_connected
/*sock_connected
  checks if a sock is connected and functioning
  argument0: sock id to check
  returns: 1 = connected, 0 = not
*/
if (argument0 < 0)
   return 0;
if (sock_getpeerip(argument0) == "")
   return 0;
else
   return 1;
   


#define sock_gettype
/* sock_gettype: checks if a socket is a normal, or listening socket.
   first arg: the socket to check
   returns: 0 for normal socket, 1 for listening socket, -1 for invalid socket
*/
if (argument0 < 0)
   return -1;
if (ds_map_exists(global._GMSOCK_BUFFER,string(argument0)))
   return 0;
else
   return 1;


#define sock_mac
/*sock_MAC: returns the mac address of the first NIC card on the host computer.
  returns: The mac(hardware) address of the NIC card (string).
  
  NOTE about MAC address: An MAC address is a static(doesn't change) unique ID
  for a NIC card(or any piece of hardware). You can use it to ban users w/ a specific MAC address, as it will not change.
*/
return external_call(global._GMSOCK_MAC);


#define udp_connect
/* udp_connect
   creates a udp socket.
   first arg:   port number the socket should use if it is udp_receive'd on. If you don't plan on recieving, 
                set this to 0.
   second arg:  0 = sync, 1 = async.
   returns:     a udp socket id.
*/
return external_call(global._GMSOCK_UCN,argument0,argument1);


#define udp_disconnect
/* udp_disconnect
   disconnects a udp socket.
   first arg:   the socket returned by udp_connect to disconnect
   returns: 1 for success, < 0 for error
*/
if (argument0 < 0)
   return -1;
return external_call(global._GMSOCK_CLO,argument0);


#define udp_send
/* udp_send
   sends a packet on a udp socket
   first arg:   a udp socket id returned by udp_connect
   second arg:  the ipaddress to send the packet to
   third arg:   the port to send the packet to
   forth arg:   the message to send in the packet
   returns:     the number of characters sent. THIS MAY BE LOWER THAN THE SIZE OF THE MESSAGE!! 
                Or < 0 for an error
*/
if (argument0 < 0)
   return -1;
return external_call(global._GMSOCK_USN,argument0,argument1,argument2,argument3);


#define udp_receive
/* udp_receive
   reads a packet from the port that the udp socket is connected to.
   first arg:   a udp socket returned by udp_connect
   returns:     the string received in the packet, or "" on error.
   
   NOTE:    After a successful udp_receive, additional packet info may be obtained.
            see the udp_packet functions.
*/
if (argument0 < 0)
   return "";
return external_call(global._GMSOCK_URC,argument0);


#define udp_pack_ipaddr
/* udp_pack_ipaddr
   returns the ip address of the most recently received packet.
*/
return external_call(global._GMSOCK_UIP);


#define udp_setasync
/*udp_setasync
   let's u change a synchronous udp socket into an asynchronous one or vice-versa
   first arg: the socket id returned from udp_connect
   second arg: 0 to make socket sync, 1 to make it async
   returns: a negative error code on an error, or 1 
*/
if (argument0 < 0)
   return -1;
return external_call(global._GMSOCK_ASY,argument0,argument1);


#define sock_group_create
/* sock_group_create: Creates a socket group, for use w/ the other sock_group functions
   returns: the new socket group id */
var tmp;
tmp = ds_list_create();
ds_map_add(global._GMSOCK_ITER,string(tmp),0);
return tmp;


#define sock_group_connect
/*sock_group_connect
  creates a socket connected to a remote host, and places it in the group.
  first arg: string w/ an IP address
  second arg: real w/ a port number
  third arg: 0 = blocking, 1 = asynchronous. 
  forth arg: the id of the group, returned by sock_group_create()
  returns: the new socket ID that was placed in the group, or a negative error code.
*/
var sock;
sock = sock_connect(argument0,argument1,argument2);
if (sock > 0)
   ds_list_add(argument3,sock);
return sock;


#define sock_group_bind
/*sock_group_bind
prepares a socket for accepting connections, and adds it to a socket group.
first arg: the port number to listen on
second arg: the max number of connections that can be trying to connect before 
you call sock_accept.
third arg: the socket group to add it to
returns: the socket ID that was added to the group, or a negative error code on error.
*/
var sock;
sock = sock_bind(argument0,argument1);
if (sock > 0)
   ds_list_add(argument2,sock);
return sock;


#define sock_group_accept
/*sock_accept
accepts 1 connection from any of the listening sockets in the group, and places it in the same group.
first arg: 1 if the NEW socket should be asynchrounous, 0 if not 
second arg: the socket group
returns: the new socket that was added to the group, or -1 if no connection was accepted
*/
var sock,ctr;
ctr = 0;
sock = -1;
while (ctr < ds_list_size(argument1)) {
   if (sock_gettype(ds_list_find_value(argument1,ctr)) == 1) {
      sock = sock_accept(ds_list_find_value(argument1,ctr),argument0);
      if (sock > 0) {
         ds_list_add(argument1,sock);
         break;
      }
   }
   ctr+=1;
}
return sock;


#define sock_group_send
/* sock_group_send
   sends a string to every normal socket in a group
   first arg: the string that should be sent
   second arg: the socket group id
   returns: the number of characters sent to one socket.
*/
var sent,ctr;
sent = 0;
ctr = 0;
while (ctr < ds_list_size(argument1)) {
   if (sock_gettype(ds_list_find_value(argument1,ctr)) == 0) {
      sent = sock_send(ds_list_find_value(argument1,ctr),argument0);
   }
   ctr+=1;
}
return sent;


#define sock_group_token_send
/* sock_group_send
   sends a token to every normal socket in a group
   first arg: the string that should be sent
   second arg: the token delimter
   third arg: the socket group id
   returns: the number of characters sent to one socket.
*/
var sent,ctr;
sent = 0;
ctr = 0;
while (ctr < ds_list_size(argument2)) {
   if (sock_gettype(ds_list_find_value(argument2,ctr)) == 0) {
      sent = sock_token_send(ds_list_find_value(argument2,ctr),argument0,argument1);
   }
   ctr+=1;
}
return sent;


#define sock_group_disconnect
/* sock_group_disconnect
   disconnects a socket, and removes it from the group.
   first arg: the socket to disconnect and remove.
   second arg: the group that contains the socket.
   returns 1 if successfull, 0 if socket is not in group.
*/
if (argument0 < 0)
   return 0;
if (ds_list_find_index(argument1,argument0) == -1)
   return 0;
sock_disconnect(argument0);
ds_list_delete(argument1,ds_list_find_index(argument1,argument0));
return 1;


#define sock_group_size
/* sock_group_size
   returns the number of sockets in a group(both listening and normal)
   first arg: the group to count in
   returns: the total number of sockets, 0 if empty.
*/
return ds_list_size(argument1);


#define sock_group_disconnectall
/* sock_group_disconnectall
   disconnects and removes all sockets in a group.
   first arg: the group to remove form
   returns: 1
*/
var ctr;
ctr = 0;
while (ctr < ds_list_size(argument0))
   sock_group_disconnect(ds_list_find_value(argument0,ctr));
return 1;


#define sock_group_destroy
/* sock_group_remove
   removes a socket group from memory. THIS WILL NOT DISCONNECT SOCKETS
   first arg: the group to remove
   returns 1
*/
ds_list_destroy(argument0);
ds_map_delete(global._GMSOCK_ITER,argument0);
return 1;


#define sock_group_iterate
/* sock_group_iterate
   returns the next socket a socket group. If there are no more sockets, returns -1. After returning -1,
   starts at the first socket, on the next call.
   first arg: the socket group
   returns: the next socket, or -1 if the end has been reached
   
   NOTE: This function may return a listening socket, if one exists in the group.
*/
var ctr;
ctr = ds_map_find_value(global._GMSOCK_ITER,string(argument0));
if (ctr >= ds_list_size(argument0)) {
   ds_map_replace(global._GMSOCK_ITER,string(argument0),0);
   return -1;
} else {
   ds_map_replace(global._GMSOCK_ITER,string(argument0),ctr+1);
   return ds_list_find_value(argument0,ctr);
}

