#define force_declare
//Force Feedback Dll by Alexander Vourtsis
//Call this before using the dll
//The Lib name, should be force.dll unless you rename or move it
global.forcelib=working_directory+"/force.dll"
//Initialize the dll functions
global.initForce=external_define("gamepad.dll","_initForce",dll_cdecl,ty_string,1,ty_string)
global.loadForce=external_define("gamepad.dll","_loadFFEffect",dll_cdecl,ty_string,2,ty_string,ty_string)
global.playForce=external_define("gamepad.dll","_playLoadedEffect",dll_cdecl,ty_string,1,ty_string)
global.getButtons=external_define("gamepad.dll","_getJoyButtons",dll_cdecl,ty_real,1,ty_string)
global.getAxis=external_define("gamepad.dll","_getJoyAxis",dll_cdecl,ty_real,1,ty_string)
global.getPNum=external_define("gamepad.dll","_getJoyNum",dll_cdecl,ty_real,1,ty_string)
global.getPovs=external_define("gamepad.dll","_getJoyPov",dll_cdecl,ty_real,1,ty_string)
global.releaseForce=external_define("gamepad.dll","_releaseForce",dll_cdecl,ty_string,1,ty_string)
#define force_initialize
//Initialize the forces
external_call(global.initForce,global.forcelib)
#define force_load_effect
//Load a force feedback effect (.ffe)
//argument0 is the .ffe filename
external_call(global.loadForce,global.forcelib,argument0)
#define force_play_effect
//Plays an effect after you have loaded it.
//NOTE: Do not call this function continiously or in a step event as it will freeze the game.
external_call(global.playForce,global.forcelib)
#define force_get_buttons
//Returns the gamepad buttons
external_call(global.getButtons,global.forcelib)
#define force_get_axis
//Returns the gamepad axes
external_call(global.getAxis,global.forcelib)
#define force_get_padnum
//Returns the gamepad number
external_call(global.getPNum,global.forcelib)
#define force_get_povs
//Returns the gamepad point of views
external_call(global.getPovs,global.forcelib)
#define force_release
//Releases all forces
//You need to reinitialize them if you use this function
external_call(global.releaseForce,global.forcelib)
