#define sxms_create
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxms_create(filename,errorMessages);
===
argument0 = STRING - The path and filename of the SXMS-3.dll
argument1 = REAL - Whether FMOD error messages should display
===
return = REAL - An instance ID to the sxms object or -1 if failed
===
//Com:
      This should be used first to setup the SXMS-3.dll in Game Maker.
      
      Note that you MUST make a "dummy" object called sxms in order for this
      to work.  This script takes care of defining the object's parameters.
*/
if (instance_exists(sxms)) { return -1; };
object_set_persistent(sxms,1);
object_set_visible(sxms,0);

object_event_add(sxms,ev_create,0,'status = sxms_internal("'+string(argument0)+'",'+string(argument1)+');');
object_event_add(sxms,ev_destroy,0,'external_free(dll);');

return instance_create(0,0,sxms);
#define sxms_internal
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
Arguments taken care of by sxms_create()
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This is used internally by the sxms object when it's created.
      So you shouldn't call this function directly.

      Note that this will fill a variable called "status" in the sxms object.
      Check that variable for the return value.
*/

/*Initialize Constants*/
FMOD_OUTPUTTYPE_AUTODETECT              = 0;
FMOD_OUTPUTTYPE_UNKNOWN                 = 1;
FMOD_OUTPUTTYPE_NOSOUND                 = 2;
FMOD_OUTPUTTYPE_WAVWRITER               = 3;
FMOD_OUTPUTTYPE_NOSOUND_NRT             = 4;
FMOD_OUTPUTTYPE_WAVWRITER_NRT           = 5;
FMOD_OUTPUTTYPE_DSOUND                  = 6;
FMOD_OUTPUTTYPE_WINMM                   = 7;
FMOD_OUTPUTTYPE_ASIO                    = 8;

FMOD_CAPS_NONE                          = $0;
FMOD_CAPS_HARDWARE                      = $1;
FMOD_CAPS_HARDWARE_EMULATED             = $2;
FMOD_CAPS_OUTPUT_MULTICHANNEL           = $4;
FMOD_CAPS_OUTPUT_PCM8                   = $8;
FMOD_CAPS_OUTPUT_PCM16                  = $10;
FMOD_CAPS_OUTPUT_PCM24                  = $20;
FMOD_CAPS_OUTPUT_PCM32                  = $40;
FMOD_CAPS_OUTPUT_PCMFLOAT               = $80;
FMOD_CAPS_REVERB_EAX2                   = $100;
FMOD_CAPS_REVERB_EAX3                   = $200;
FMOD_CAPS_REVERB_EAX4                   = $400;
FMOD_CAPS_REVERB_I3DL2                  = $800;
FMOD_CAPS_REVERB_LIMITED                = $1000;

FMOD_SPEAKERMODE_RAW                    = 0;
FMOD_SPEAKERMODE_MONO                   = 1;
FMOD_SPEAKERMODE_STEREO                 = 2;
FMOD_SPEAKERMODE_QUAD                   = 3;
FMOD_SPEAKERMODE_SURROUND               = 4;
FMOD_SPEAKERMODE_5POINT1                = 5;
FMOD_SPEAKERMODE_7POINT1                = 6;
FMOD_SPEAKERMODE_PROLOGIC               = 7;

FMOD_SPEAKER_FRONT_LEFT                 = 0;
FMOD_SPEAKER_FRONT_RIGHT                = 1;
FMOD_SPEAKER_FRONT_CENTER               = 2;
FMOD_SPEAKER_LOW_FREQUENCY              = 3;
FMOD_SPEAKER_BACK_LEFT                  = 4;
FMOD_SPEAKER_BACK_RIGHT                 = 5;
FMOD_SPEAKER_SIDE_LEFT                  = 6;
FMOD_SPEAKER_SIDE_RIGHT                 = 7;
FMOD_SPEAKER_MAX                        = 8;
FMOD_SPEAKER_MONO                       = FMOD_SPEAKER_FRONT_LEFT;
FMOD_SPEAKER_BACK_CENTER                = FMOD_SPEAKER_LOW_FREQUENCY;

FMOD_PLUGINTYPE_OUTPUT                  = 0;
FMOD_PLUGINTYPE_CODEC                   = 1;
FMOD_PLUGINTYPE_DSP                     = 2;

FMOD_INIT_NORMAL                        = $0;
FMOD_INIT_STREAM_FROM_UPDATE            = $1;
FMOD_INIT_3D_RIGHTHANDED                = $2;
FMOD_INIT_DISABLESOFTWARE               = $4;
FMOD_INIT_OCCLUSION_LOWPASS             = $8;
FMOD_INIT_DSOUND_HRTFNONE               = $200;
FMOD_INIT_DSOUND_HRTFLIGHT              = $400;
FMOD_INIT_DSOUND_HRTFFULL               = $800;

FMOD_SOUND_TYPE_UNKNOWN                 = 0;
FMOD_SOUND_TYPE_AAC                     = 1;
FMOD_SOUND_TYPE_AIFF                    = 2;
FMOD_SOUND_TYPE_ASF                     = 3;
/*FMOD_SOUND_TYPE_AT3                   = 4;*/
FMOD_SOUND_TYPE_CDDA                    = 5;
FMOD_SOUND_TYPE_DLS                     = 6;
FMOD_SOUND_TYPE_FLAC                    = 7;
FMOD_SOUND_TYPE_FSB                     = 8;
/*FMOD_SOUND_TYPE_GCADPCM               = 9;*/
FMOD_SOUND_TYPE_IT                      = 10;
FMOD_SOUND_TYPE_MIDI                    = 11;
FMOD_SOUND_TYPE_MOD                     = 12;
FMOD_SOUND_TYPE_MPEG                    = 13;
FMOD_SOUND_TYPE_OGGVORBIS               = 14;
FMOD_SOUND_TYPE_PLAYLIST                = 15;
FMOD_SOUND_TYPE_RAW                     = 16;
FMOD_SOUND_TYPE_S3M                     = 17;
FMOD_SOUND_TYPE_SF2                     = 18;
FMOD_SOUND_TYPE_USER                    = 19;
FMOD_SOUND_TYPE_WAV                     = 20;
FMOD_SOUND_TYPE_XM                      = 21;
/*FMOD_SOUND_TYPE_XMA                   = 22;*/
FMOD_SOUND_TYPE_VAG                     = 23;

FMOD_SOUND_FORMAT_NONE                  = 0;
FMOD_SOUND_FORMAT_PCM8                  = 1;
FMOD_SOUND_FORMAT_PCM16                 = 2;
FMOD_SOUND_FORMAT_PCM24                 = 3;
FMOD_SOUND_FORMAT_PCM32                 = 4;
FMOD_SOUND_FORMAT_PCMFLOAT              = 5;
FMOD_SOUND_FORMAT_VAG                   = 8;
FMOD_SOUND_FORMAT_MPEG                  = 10;

FMOD_DEFAULT                            = $0;
FMOD_LOOP_OFF                           = $1;
FMOD_LOOP_NORMAL                        = $2;
FMOD_LOOP_BIDI                          = $4;
FMOD_2D                                 = $8;
FMOD_3D                                 = $10;
FMOD_HARDWARE                           = $20;
FMOD_SOFTWARE                           = $40;
FMOD_CREATESTREAM                       = $80;
FMOD_CREATESAMPLE                       = $100;
FMOD_CREATECOMPRESSEDSAMPLE             = $200;
FMOD_OPENUSER                           = $400;
FMOD_OPENMEMORY                         = $800;
FMOD_OPENMEMORY_POINT                   = $10000000;
FMOD_OPENRAW                            = $1000;
FMOD_OPENONLY                           = $2000;
FMOD_ACCURATETIME                       = $4000;
FMOD_MPEGSEARCH                         = $8000;
FMOD_NONBLOCKING                        = $10000;
FMOD_UNIQUE                             = $20000;
FMOD_3D_HEADRELATIVE                    = $40000;
FMOD_3D_WORLDRELATIVE                   = $80000;
FMOD_3D_LOGROLLOFF                      = $100000;
FMOD_3D_LINEARROLLOFF                   = $200000;
FMOD_3D_CUSTOMROLLOFF                   = $4000000;
FMOD_CDDA_FORCEASPI                     = $400000;
FMOD_CDDA_JITTERCORRECT                 = $800000;
FMOD_UNICODE                            = $1000000;
FMOD_IGNORETAGS                         = $2000000;
FMOD_LOWMEM                             = $8000000;
FMOD_LOADSECONDARYRAM                   = $20000000;
/*FMOD_NORMAL                             = (FMOD_HARDWARE|FMOD_LOOP_OFF|FMOD_2D);*/

SXMS_MUSIC                              = (FMOD_SOFTWARE|FMOD_CREATESTREAM|FMOD_2D);
SXMS_SFX                                = (FMOD_SOFTWARE|FMOD_2D);

FMOD_OPENSTATE_READY                    = 0;
FMOD_OPENSTATE_LOADING                  = 1;
FMOD_OPENSTATE_ERROR                    = 2;
FMOD_OPENSTATE_CONNECTING               = 3;
FMOD_OPENSTATE_BUFFERING                = 4;
FMOD_OPENSTATE_SEEKING                  = 5;

FMOD_DSP_FFT_WINDOW_RECT                = 0;
FMOD_DSP_FFT_WINDOW_TRIANGLE            = 1;
FMOD_DSP_FFT_WINDOW_HAMMING             = 2;
FMOD_DSP_FFT_WINDOW_HANNING             = 3;
FMOD_DSP_FFT_WINDOW_BLACKMAN            = 4;
FMOD_DSP_FFT_WINDOW_BLACKMANHARRIS      = 5;
FMOD_DSP_FFT_WINDOW_MAX                 = 6;

FMOD_DSP_RESAMPLER_NOINTERP             = 0;
FMOD_DSP_RESAMPLER_LINEAR               = 1;
FMOD_DSP_RESAMPLER_CUBIC                = 2;
FMOD_DSP_RESAMPLER_SPLINE               = 3;

FMOD_TAGTYPE_UNKNOWN                    = 0;
FMOD_TAGTYPE_ID3V1                      = 1;
FMOD_TAGTYPE_ID3V2                      = 2;
FMOD_TAGTYPE_VORBISCOMMENT              = 3;
FMOD_TAGTYPE_SHOUTCAST                  = 4;
FMOD_TAGTYPE_ICECAST                    = 5;
FMOD_TAGTYPE_ASF                        = 6;
FMOD_TAGTYPE_MIDI                       = 7;
FMOD_TAGTYPE_PLAYLIST                   = 8;
FMOD_TAGTYPE_FMOD                       = 9;
FMOD_TAGTYPE_USER                       = 10;

FMOD_TAGDATATYPE_BINARY                 = 0;
FMOD_TAGDATATYPE_INT                    = 1;
FMOD_TAGDATATYPE_FLOAT                  = 2;
FMOD_TAGDATATYPE_STRING                 = 3;
FMOD_TAGDATATYPE_STRING_UTF16           = 4;
FMOD_TAGDATATYPE_STRING_UTF16BE         = 5;
FMOD_TAGDATATYPE_STRING_UTF8            = 6;
FMOD_TAGDATATYPE_CDTOC                  = 7;

FMOD_TIMEUNIT_MS                        = $1;
FMOD_TIMEUNIT_PCM                       = $2;
FMOD_TIMEUNIT_PCMBYTES                  = $4;
FMOD_TIMEUNIT_RAWBYTES                  = $8;
FMOD_TIMEUNIT_MODORDER                  = $100;
FMOD_TIMEUNIT_MODROW                    = $200;
FMOD_TIMEUNIT_MODPATTERN                = $400;
FMOD_TIMEUNIT_SENTENCE_MS               = $10000;
FMOD_TIMEUNIT_SENTENCE_PCM              = $20000;
FMOD_TIMEUNIT_SENTENCE_PCMBYTES         = $40000;
FMOD_TIMEUNIT_SENTENCE                  = $80000;
FMOD_TIMEUNIT_SENTENCE_SUBSOUND         = $100000;
FMOD_TIMEUNIT_BUFFERED                  = $10000000;

FMOD_CHANNEL_FREE                       = -1;
FMOD_CHANNEL_REUSE                      = -2;

for (i = 0; i < 18; i += 1) {
    FMOD_CREATESOUNDEXINFO[i] = 0;
};
FMOD_CREATESOUNDEXINFO[9] = "";
FMOD_CREATESOUNDEXINFO[14] = "";
FMOD_CREATESOUNDEXINFO[15] = "";

/*DSP Constants*/
FMOD_DSP_TYPE_UNKNOWN                   = 0;
FMOD_DSP_TYPE_MIXER                     = 1;
FMOD_DSP_TYPE_OSCILLATOR                = 2;
FMOD_DSP_TYPE_LOWPASS                   = 3;
FMOD_DSP_TYPE_ITLOWPASS                 = 4;
FMOD_DSP_TYPE_HIGHPASS                  = 5;
FMOD_DSP_TYPE_ECHO                      = 6;
FMOD_DSP_TYPE_FLANGE                    = 7;
FMOD_DSP_TYPE_DISTORTION                = 8;
FMOD_DSP_TYPE_NORMALIZE                 = 9;
FMOD_DSP_TYPE_PARAMEQ                   = 10;
FMOD_DSP_TYPE_PITCHSHIFT                = 11;
FMOD_DSP_TYPE_CHORUS                    = 12;
FMOD_DSP_TYPE_REVERB                    = 13;
FMOD_DSP_TYPE_VSTPLUGIN                 = 14;
FMOD_DSP_TYPE_WINAMPPLUGIN              = 15;
FMOD_DSP_TYPE_ITECHO                    = 16;
FMOD_DSP_TYPE_COMPRESSOR                = 17;
FMOD_DSP_TYPE_SFXREVERB                 = 18;
FMOD_DSP_TYPE_LOWPASS_SIMPLE            = 19;

FMOD_DSP_OSCILLATOR_TYPE                = 0; /* Waveform type.  0 = sine.  1 = square. 2 = sawup. 3 = sawdown. 4 = triangle. 5 = noise.  */
FMOD_DSP_OSCILLATOR_RATE                = 1; /* Frequency of the sinewave in hz.  1.0 to 22000.0.  Default = 220.0. */

FMOD_DSP_LOWPASS_CUTOFF                 = 0; /* Lowpass cutoff frequency in hz.   1.0 to 22000.0.  Default = 5000.0. */
FMOD_DSP_LOWPASS_RESONANCE              = 1; /* Lowpass resonance Q value. 1.0 to 10.0.  Default = 1.0. */

FMOD_DSP_ITLOWPASS_CUTOFF               = 0; /* Lowpass cutoff frequency in hz.  1.0 to 22000.0.  Default = 5000.0/ */
FMOD_DSP_ITLOWPASS_RESONANCE            = 1; /* Lowpass resonance Q value.  0.0 to 127.0.  Default = 1.0. */

FMOD_DSP_HIGHPASS_CUTOFF                = 0; /* Highpass cutoff frequency in hz.  10.0 to output 22000.0.  Default = 5000.0. */
FMOD_DSP_HIGHPASS_RESONANCE             = 1; /* Highpass resonance Q value.  1.0 to 10.0.  Default = 1.0. */

FMOD_DSP_ECHO_DELAY                     = 0; /* Echo delay in ms.  10  to 5000.  Default = 500. */
FMOD_DSP_ECHO_DECAYRATIO                = 1; /* Echo decay per delay.  0 to 1.  1.0 = No decay, 0.0 = total decay (ie simple 1 line delay).  Default = 0.5. */
FMOD_DSP_ECHO_MAXCHANNELS               = 2; /* Maximum channels supported.  0 to 16.  0 = same as fmod's default output polyphony, 1 = mono, 2 = stereo etc.  See remarks for more.  Default = 0.  It is suggested to leave at 0! */
FMOD_DSP_ECHO_DRYMIX                    = 3; /* Volume of original signal to pass to output.  0.0 to 1.0. Default = 1.0. */
FMOD_DSP_ECHO_WETMIX                    = 4; /* Volume of echo signal to pass to output.  0.0 to 1.0. Default = 1.0. */

FMOD_DSP_FLANGE_DRYMIX                  = 0; /* Volume of original signal to pass to output.  0.0 to 1.0. Default = 0.45. */
FMOD_DSP_FLANGE_WETMIX                  = 1; /* Volume of flange signal to pass to output.  0.0 to 1.0. Default = 0.55. */
FMOD_DSP_FLANGE_DEPTH                   = 2; /* Flange depth.  0.01 to 1.0.  Default = 1.0. */
FMOD_DSP_FLANGE_RATE                    = 3; /* Flange speed in hz.  0.0 to 20.0.  Default = 0.1. */

FMOD_DSP_DISTORTION_LEVEL               = 0; /* Distortion value.  0.0 to 1.0.  Default = 0.5. */

FMOD_DSP_NORMALIZE_FADETIME             = 0; /* Time to ramp the silence to full in ms.  0.0 to 20000.0. Default = 5000.0. */
FMOD_DSP_NORMALIZE_THRESHHOLD           = 1; /* Lower volume range threshold to ignore.  0.0 to 1.0.  Default = 0.1.  Raise higher to stop amplification of very quiet signals. */
FMOD_DSP_NORMALIZE_MAXAMP               = 2; /* Maximum amplification allowed.  1.0 to 100000.0.  Default = 20.0.  1.0 = no amplifaction, higher values allow more boost. */

FMOD_DSP_PARAMEQ_CENTER                 = 0; /* Frequency center.  20.0 to 22000.0.  Default = 8000.0. */
FMOD_DSP_PARAMEQ_BANDWIDTH              = 1; /* Octave range around the center frequency to filter.  0.2 to 5.0.  Default = 1.0. */
FMOD_DSP_PARAMEQ_GAIN                   = 2; /* Frequency Gain.  0.05 to 3.0.  Default = 1.0.  */

FMOD_DSP_PITCHSHIFT_PITCH               = 0; /* Pitch value.  0.5 to 2.0.  Default = 1.0. 0.5 = one octave down, 2.0 = one octave up.  1.0 does not change the pitch. */
FMOD_DSP_PITCHSHIFT_FFTSIZE             = 1; /* FFT window size.  256, 512, 1024, 2048, 4096.  Default = 1024.  Increase this to reduce 'smearing'.  This effect is a warbling sound similar to when an mp3 is encoded at very low bitrates. */
FMOD_DSP_PITCHSHIFT_OVERLAP             = 2; /* Window overlap.  1 to 32.  Default = 4.  Increase this to reduce 'tremolo' effect.  Increasing it by a factor of 2 doubles the CPU usage. */
FMOD_DSP_PITCHSHIFT_MAXCHANNELS         = 3; /* Maximum channels supported.  0 to 16.  0 = same as fmod's default output polyphony, 1 = mono, 2 = stereo etc.  See remarks for more.  Default = 0.  It is suggested to leave at 0! */

FMOD_DSP_CHORUS_DRYMIX                  = 0; /* Volume of original signal to pass to output.  0.0 to 1.0. Default = 0.5. */
FMOD_DSP_CHORUS_WETMIX1                 = 1; /* Volume of 1st chorus tap.  0.0 to 1.0.  Default = 0.5. */
FMOD_DSP_CHORUS_WETMIX2                 = 2; /* Volume of 2nd chorus tap. This tap is 90 degrees out of phase of the first tap.  0.0 to 1.0.  Default = 0.5. */
FMOD_DSP_CHORUS_WETMIX3                 = 3; /* Volume of 3rd chorus tap. This tap is 90 degrees out of phase of the second tap.  0.0 to 1.0.  Default = 0.5. */
FMOD_DSP_CHORUS_DELAY                   = 4; /* Chorus delay in ms.  0.1 to 100.0.  Default = 40.0 ms. */
FMOD_DSP_CHORUS_RATE                    = 5; /* Chorus modulation rate in hz.  0.0 to 20.0.  Default = 0.8 hz. */
FMOD_DSP_CHORUS_DEPTH                   = 6; /* Chorus modulation depth.  0.0 to 1.0.  Default = 0.03. */
FMOD_DSP_CHORUS_FEEDBACK                = 7; /* Chorus feedback.  Controls how much of the wet signal gets fed back into the chorus buffer.  0.0 to 1.0.  Default = 0.0. */

FMOD_DSP_REVERB_ROOMSIZE                = 0; /* Roomsize. 0.0 to 1.0.  Default = 0.5 */
FMOD_DSP_REVERB_DAMP                    = 1; /* Damp.     0.0 to 1.0.  Default = 0.5 */
FMOD_DSP_REVERB_WETMIX                  = 2; /* Wet mix.  0.0 to 1.0.  Default = 0.33 */
FMOD_DSP_REVERB_DRYMIX                  = 3; /* Dry mix.  0.0 to 1.0.  Default = 0.66 */
FMOD_DSP_REVERB_WIDTH                   = 4; /* Stereo width. 0.0 to 1.0.  Default = 1.0 */
FMOD_DSP_REVERB_MODE                    = 5; /* Mode.     0 (normal), 1 (freeze).  Default = 0 */

FMOD_DSP_ITECHO_WETDRYMIX               = 0; /* Ratio of wet (processed) signal to dry (unprocessed) signal. Must be in the range from 0.0 through 100.0 (all wet). The default value is 50. */
FMOD_DSP_ITECHO_FEEDBACK                = 1; /* Percentage of output fed back into input, in the range from 0.0 through 100.0. The default value is 50. */
FMOD_DSP_ITECHO_LEFTDELAY               = 2; /* Delay for left channel, in milliseconds, in the range from 1.0 through 2000.0. The default value is 500 ms. */
FMOD_DSP_ITECHO_RIGHTDELAY              = 3; /* Delay for right channel, in milliseconds, in the range from 1.0 through 2000.0. The default value is 500 ms. */
FMOD_DSP_ITECHO_PANDELAY                = 4; /* Value that specifies whether to swap left and right delays with each successive echo. The default value is zero, meaning no swap. Possible values are defined as 0.0 (equivalent to FALSE) and 1.0 (equivalent to TRUE).  CURRENTLY NOT SUPPORTED. */

FMOD_DSP_COMPRESSOR_THRESHOLD           = 0; /* Threshold level (dB)in the range from -60 through 0. The default value is 50. */
FMOD_DSP_COMPRESSOR_ATTACK              = 1; /* Gain reduction attack time (milliseconds), in the range from 10 through 200. The default value is 50. */
FMOD_DSP_COMPRESSOR_RELEASE             = 2; /* Gain reduction release time (milliseconds), in the range from 20 through 1000. The default value is 50. */
FMOD_DSP_COMPRESSOR_GAINMAKEUP          = 3; /* Make-up gain applied after limiting, in the range from 0.0 through 100.0. The default value is 50. */

FMOD_DSP_SFXREVERB_DRYLEVE              = 0; /* Dry Level      : Mix level of dry signal in output in mB.  Ranges from -10000.0 to 0.0.  Default is 0.0. */
FMOD_DSP_SFXREVERB_ROOM                 = 1; /* Room           : Room effect level at low frequencies in mB.  Ranges from -10000.0 to 0.0.  Default is 0.0. */
FMOD_DSP_SFXREVERB_ROOMHF               = 2; /* Room HF        : Room effect high-frequency level re. low frequency level in mB.  Ranges from -10000.0 to 0.0.  Default is 0.0. */
FMOD_DSP_SFXREVERB_ROOMROLLOFFFACTOR    = 3; /* Room Rolloff   : Like DS3D flRolloffFactor but for room effect.  Ranges from 0.0 to 10.0. Default is 10.0 */
FMOD_DSP_SFXREVERB_DECAYTIME            = 4; /* Decay Time     : Reverberation decay time at low-frequencies in seconds.  Ranges from 0.1 to 20.0. Default is 1.0. */
FMOD_DSP_SFXREVERB_DECAYHFRATIO         = 5; /* Decay HF Ratio : High-frequency to low-frequency decay time ratio.  Ranges from 0.1 to 2.0. Default is 0.5. */
FMOD_DSP_SFXREVERB_REFLECTIONSLEVEL     = 6; /* Reflections    : Early reflections level relative to room effect in mB.  Ranges from -10000.0 to 1000.0.  Default is -10000.0. */
FMOD_DSP_SFXREVERB_REFLECTIONSDELAY     = 7; /* Reflect Delay  : Delay time of first reflection in seconds.  Ranges from 0.0 to 0.3.  Default is 0.02. */
FMOD_DSP_SFXREVERB_REVERBLEVEL          = 8; /* Reverb         : Late reverberation level relative to room effect in mB.  Ranges from -10000.0 to 2000.0.  Default is 0.0. */
FMOD_DSP_SFXREVERB_REVERBDELAY          = 9; /* Reverb Delay   : Late reverberation delay time relative to first reflection in seconds.  Ranges from 0.0 to 0.1.  Default is 0.04. */
FMOD_DSP_SFXREVERB_DIFFUSION            = 10; /* Diffusion      : Reverberation diffusion (echo density) in percent.  Ranges from 0.0 to 100.0.  Default is 100.0. */
FMOD_DSP_SFXREVERB_DENSITY              = 11; /* Density        : Reverberation density (modal density) in percent.  Ranges from 0.0 to 100.0.  Default is 100.0. */
FMOD_DSP_SFXREVERB_HFREFERENCE          = 12; /* HF Reference   : Reference high frequency in Hz.  Ranges from 20.0 to 20000.0. Default is 5000.0. */

FMOD_DSP_LOWPASS_SIMPLE_CUTOFF          = 0; /* Lowpass cutoff frequency in hz.  10.0 to 22000.0.  Default = 5000.0 */

dll = argument0;
if (!file_exists(dll)) { return 0; };
/*Constants*/
dll_sxfmod_CREATESOUNDEXINFO1 = external_define(dll,"sxfmod_CREATESOUNDEXINFO1",dll_cdecl,ty_real,3,ty_string,ty_string,ty_string);
dll_sxfmod_CREATESOUNDEXINFO2 = external_define(dll,"sxfmod_CREATESOUNDEXINFO2",dll_cdecl,ty_real,11,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_CREATESOUNDEXINFO3 = external_define(dll,"sxfmod_CREATESOUNDEXINFO3",dll_cdecl,ty_real,2,ty_real,ty_real);
/*Init/General*/
dll_init = external_define(dll,"sxms_init",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_setCurrent = external_define(dll,"sxfmod_system_setCurrent",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_getSpectrum = external_define(dll,"sxfmod_getSpectrum",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getSpectrumStereo = external_define(dll,"sxfmod_system_getSpectrumStereo",dll_cdecl,ty_real,2,ty_real,ty_real);
/*FMOD Memory*/
dll_sxfmod_memory_getStats = external_define(dll,"sxfmod_memory_getStats",dll_cdecl,ty_real,1,ty_real);
/*FMOD Factory Functions*/
dll_sxfmod_system_create = external_define(dll,"sxfmod_system_create",dll_cdecl,ty_real,0);
dll_sxfmod_system_release = external_define(dll,"sxfmod_system_release",dll_cdecl,ty_real,0);
/*FMOD Pre-Init Functions*/
/*Not Currently Supported:
      dll_sxfmod_system_setFileSystem
      dll_sxfmod_system_getFileSystem*/
dll_sxfmod_system_setOutput = external_define(dll,"sxfmod_system_setOutput",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getOutput = external_define(dll,"sxfmod_system_getOutput",dll_cdecl,ty_real,0);
dll_sxfmod_system_getNumDrivers = external_define(dll,"sxfmod_system_getNumDrivers",dll_cdecl,ty_real,0);
dll_sxfmod_system_getDriverName = external_define(dll,"sxfmod_system_getDriverName",dll_cdecl,ty_string,1,ty_real);
dll_sxfmod_system_getDriverCaps = external_define(dll,"sxfmod_system_getDriverCaps",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_setDriver = external_define(dll,"sxfmod_system_setDriver",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getDriver = external_define(dll,"sxfmod_system_getDriver",dll_cdecl,ty_real,0);
dll_sxfmod_system_setDSPBufferSize = external_define(dll,"sxfmod_system_setDSPBufferSize",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_getDSPBufferSize = external_define(dll,"sxfmod_system_getDSPBufferSize",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_setHardwareChannels = external_define(dll,"sxfmod_system_setHardwareChannels",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_system_getHardwareChannels = external_define(dll,"sxfmod_system_getHardwareChannels",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_setSoftwareChannels = external_define(dll,"sxfmod_system_setSoftwareChannels",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getSoftwareChannels = external_define(dll,"sxfmod_system_getSoftwareChannels",dll_cdecl,ty_real,0);
dll_sxfmod_system_setSoftwareFormat = external_define(dll,"sxfmod_system_setSoftwareFormat",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_system_getSoftwareFormat = external_define(dll,"sxfmod_system_getSoftwareFormat",dll_cdecl,ty_real,1,ty_real);
/*FMOD Plugin Support*/
dll_sxfmod_system_setPluginPath = external_define(dll,"sxfmod_system_setPluginPath",dll_cdecl,ty_real,1,ty_string);
dll_sxfmod_system_loadPlugin = external_define(dll,"sxfmod_system_loadPlugin",dll_cdecl,ty_real,1,ty_string);
dll_sxfmod_system_getNumPlugins = external_define(dll,"sxfmod_system_getNumPlugins",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getPluginInfo = external_define(dll,"sxfmod_system_getPluginInfo",dll_cdecl,ty_string,3,ty_real,ty_real,ty_real);
dll_sxfmod_system_unloadPlugin = external_define(dll,"sxfmod_system_unloadPlugin",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_setOutputByPlugin = external_define(dll,"sxfmod_system_setOutputByPlugin",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getOutputByPlugin = external_define(dll,"sxfmod_system_getOutputByPlugin",dll_cdecl,ty_real,0);
/*FMOD Init/Close Functions*/
dll_sxfmod_system_init = external_define(dll,"sxfmod_system_init",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_system_close = external_define(dll,"sxfmod_system_close",dll_cdecl,ty_real,0);
/*FMOD General Post-Init Functions*/
/*Not Currently Supported:
      dll_sxfmod_system_set3DListenerAttriubtes
      dll_sxfmod_system_get3DlistenerAttributes*/
dll_sxfmod_system_update = external_define(dll,"sxfmod_system_update",dll_cdecl,ty_real,0);
dll_sxfmod_system_setSpeakerMode = external_define(dll,"sxfmod_system_setSpeakerMode",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getSpeakerMode = external_define(dll,"sxfmod_system_getSpeakerMode",dll_cdecl,ty_real,0);
dll_sxfmod_system_setSpeakerPosition = external_define(dll,"sxfmod_system_setSpeakerPosition",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_system_getSpeakerPosition = external_define(dll,"sxfmod_system_getSpeakerPosition",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_set3DSettings = external_define(dll,"sxfmod_system_set3DSettings",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_system_get3DSettings = external_define(dll,"sxfmod_system_get3DSettings",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_set3DNumListeners = external_define(dll,"sxfmod_system_set3DNumListeners",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_get3DNumListeners = external_define(dll,"sxfmod_system_get3DNumListeners",dll_cdecl,ty_real,0);
dll_sxfmod_system_setStreamBufferSize = external_define(dll,"sxfmod_system_setStreamBufferSize",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_getStreamBufferSize = external_define(dll,"sxfmod_system_getStreamBufferSize",dll_cdecl,ty_real,1,ty_real);
/*FMOD System Information Functions*/
/*Not Currently Supported:
      dll_sxfmod_system_getOutputHandle
      dll_sxfmod_system_getWaveData*/
dll_sxfmod_system_getVersion = external_define(dll,"sxfmod_system_getVersion",dll_cdecl,ty_real,0);
dll_sxfmod_system_getChannelsPlaying = external_define(dll,"sxfmod_system_getChannelsPlaying",dll_cdecl,ty_real,0);
dll_sxfmod_system_getCPUUsage = external_define(dll,"sxfmod_system_getCPUUsage",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getNumCDROMDrives = external_define(dll,"sxfmod_system_getNumCDROMDrives",dll_cdecl,ty_real,0);
dll_sxfmod_system_getCDROMDriveName = external_define(dll,"sxfmod_system_getCDROMDriveName",dll_cdecl,ty_string,2,ty_real,ty_real);
dll_sxfmod_system_getSpectrum = external_define(dll,"sxfmod_system_getSpectrum",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
/*FMOD (system) Sound/DSP/Channel/FX creation and retrieval*/
/*Not Currently Supported:
      dll_sxfmod_system_createStream (This isn't needed)
      dll_sxfmod_system_createDSP
      dll_sxfmod_system_createDSPByIndex*/
dll_sxfmod_system_createSound = external_define(dll,"sxfmod_system_createSound",dll_cdecl,ty_real,4,ty_string,ty_real,ty_real,ty_real);
dll_sxfmod_system_createDSPByType = external_define(dll,"sxfmod_system_createDSPByType",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_createDSPByIndex = external_define(dll,"sxfmod_system_createDSPByIndex",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_createChannelGroup = external_define(dll,"sxfmod_system_createChannelGroup",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_playSound = external_define(dll,"sxfmod_system_playSound",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_system_playDSP = external_define(dll,"sxfmod_system_playDSP",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_system_getChannel = external_define(dll,"sxfmod_system_getChannel",dll_cdecl,ty_real,1,ty_real);
/*FMOD (system) Reverb API*/
/*Not Currently Supported:
      dll_sxfmod_system_setReverbProperties
      dll_sxfmod_system_getReverbProperties*/
/*FMOD (system) System Level DSP Access*/
/*Not Currently Supported:
      dll_sxfmod_system_getDSPHead
      dll_sxfmod_system_lockDSP
      dll_sxfmod_system_unlockDSP*/
dll_sxfmod_system_addDSP = external_define(dll,"sxfmod_system_addDSP",dll_cdecl,ty_real,1,ty_real);
/*FMOD (system) Recording API*/
dll_sxfmod_system_setRecordDriver = external_define(dll,"sxfmod_system_setRecordDriver",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getRecordDriver = external_define(dll,"sxfmod_system_getRecordDriver",dll_cdecl,ty_real,0);
dll_sxfmod_system_getRecordNumDrivers = external_define(dll,"sxfmod_system_getRecordNumDrivers",dll_cdecl,ty_real,0);
dll_sxfmod_system_getRecordDriverName = external_define(dll,"sxfmod_system_getRecordDriverName",dll_cdecl,ty_string,1,ty_real);
dll_sxfmod_system_getRecordPosition = external_define(dll,"sxfmod_system_getRecordPosition",dll_cdecl,ty_real,0);
dll_sxfmod_system_recordStart = external_define(dll,"sxfmod_system_recordStart",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_system_recordStop = external_define(dll,"sxfmod_system_recordStop",dll_cdecl,ty_real,0);
dll_sxfmod_system_isRecording = external_define(dll,"sxfmod_system_isRecording",dll_cdecl,ty_real,0);
/*FMOD (system) Geometry API*/
/*Not Currently Supported:
      dll_sxfmod_system_createGeometry
      dll_sxfmod_system_setGeometrySettings
      dll_sxfmod_system_getGeometrySettings
      dll_sxfmod_system_loadGeometry*/
/*FMOD Network Functions*/
dll_sxfmod_system_setNetworkProxy = external_define(dll,"sxfmod_system_setNetworkProxy",dll_cdecl,ty_real,1,ty_string);
dll_sxfmod_system_getNetworkProxy = external_define(dll,"sxfmod_system_getNetworkProxy",dll_cdecl,ty_string,0);
dll_sxfmod_system_setNetworkTimeout = external_define(dll,"sxfmod_system_setNetworkTimeout",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_system_getNetworkTimeout = external_define(dll,"sxfmod_system_getNetworkTimeout",dll_cdecl,ty_real,0);
/*FMOD UserData*/
/*Not Currently Supported:
      dll_sxfmod_system_setUserData
      dll_sxfmod_system_getUserData*/
/*FMOD 'Sound' API*/
/*Not Currently Supported:
      dll_sxfmod_sound_getSystemObject
      dll_sxfmod_sound_lock
      dll_sxfmod_sound_unlock
      dll_sxfmod_sound_readData
      dll_sxfmod_sound_seekData*/
dll_sxfmod_sound_release = external_define(dll,"sxfmod_sound_release",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_sound_setDefaults = external_define(dll,"sxfmod_sound_setDefaults",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_sound_getDefaults = external_define(dll,"sxfmod_sound_getDefaults",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_setVariations = external_define(dll,"sxfmod_sound_setVariations",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_sound_getVariations = external_define(dll,"sxfmod_sound_getVariations",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_set3DMinMaxDistance = external_define(dll,"sxfmod_sound_set3DMinMaxDistance",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_sound_get3DMinMaxDistance = external_define(dll,"sxfmod_sound_get3DMinMaxDistance",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_set3DConeSettings = external_define(dll,"sxfmod_sound_set3DConeSettings",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_sound_get3DConeSettings = external_define(dll,"sxfmod_sound_get3DConeSettings",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_setSubSound = external_define(dll,"sxfmod_sound_setSubSound",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_sound_getSubSound = external_define(dll,"sxfmod_sound_getSubSound",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_sound_getName = external_define(dll,"sxfmod_sound_getName",dll_cdecl,ty_string,1,ty_real);
dll_sxfmod_sound_getLength = external_define(dll,"sxfmod_sound_getLength",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_getFormat = external_define(dll,"sxfmod_sound_getFormat",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_getNumSubSounds = external_define(dll,"sxfmod_sound_getNumSubSounds",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_sound_getNumTags = external_define(dll,"sxfmod_sound_getNumTags",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_getTag = external_define(dll,"sxfmod_sound_getTag",dll_cdecl,ty_string,3,ty_real,ty_real,ty_real);
dll_sxfmod_sound_getOpenState = external_define(dll,"sxfmod_sound_getOpenState",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_setMode = external_define(dll,"sxfmod_sound_setMode",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_getMode = external_define(dll,"sxfmod_sound_getMode",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_sound_setLoopCount = external_define(dll,"sxfmod_sound_setLoopCount",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_sound_getLoopCount = external_define(dll,"sxfmod_sound_getLoopCount",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_sound_setLoopPoints = external_define(dll,"sxfmod_sound_setLoopPoints",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_sound_getLoopPoints = external_define(dll,"sxfmod_sound_getLoopPoints",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
/*FMOD (sound) UserData*/
/*Not Currently Supported:
      dll_sxfmod_sound_setUserData
      dll_sxfmod_sound_getUserData*/
/*FMOD 'Channel' API*/
/*Not Currently Supported:
      dll_sxfmod_channel_getSystemObject
      dll_sxfmod_channel_setReverbProperties
      dll_sxfmod_channel_getReverbProperties
      dll_sxfmod_channel_getCurrentSound
      dll_sxfmod_channel_getWaveData
      dll_sxfmod_channel_setCallback
      dll_sxfmod_channel_getDSPHead
      dll_sxfmod_channel_setNextSound
      dll_sxfmod_channel_getNextSound
      dll_sxfmod_channel_setUserData
      dll_sxfmod_channel_getUserData*/
dll_sxfmod_channel_stop = external_define(dll,"sxfmod_channel_stop",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setPaused = external_define(dll,"sxfmod_channel_setPaused",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getPaused = external_define(dll,"sxfmod_channel_getPaused",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setVolume = external_define(dll,"sxfmod_channel_setVolume",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getVolume = external_define(dll,"sxfmod_channel_getVolume",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setFrequency = external_define(dll,"sxfmod_channel_setFrequency",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getFrequency = external_define(dll,"sxfmod_channel_getFrequency",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setPan = external_define(dll,"sxfmod_channel_setPan",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getPan = external_define(dll,"sxfmod_channel_getPan",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setDelay = external_define(dll,"sxfmod_channel_setDelay",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_channel_getDelay = external_define(dll,"sxfmod_channel_getDelay",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_setSpeakerMix = external_define(dll,"sxfmod_channel_setSpeakerMix",dll_cdecl,ty_real,9,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_getSpeakerMix = external_define(dll,"sxfmod_channel_getSpeakerMix",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_setSpeakerLevels = external_define(dll,"sxfmod_channel_setSpeakerLevels",dll_cdecl,ty_real,11,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_getSpeakerLevels = external_define(dll,"sxfmod_channel_getSpeakerLevels",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_channel_setMute = external_define(dll,"sxfmod_channel_setMute",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getMute = external_define(dll,"sxfmod_channel_getMute",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setPriority = external_define(dll,"sxfmod_channel_setPriority",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getPriority = external_define(dll,"sxfmod_channel_getPriority",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setPosition = external_define(dll,"sxfmod_channel_setPosition",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_channel_getPosition = external_define(dll,"sxfmod_channel_getPosition",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_setChannelGroup = external_define(dll,"sxfmod_channel_setChannelGroup",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_set3DAttributes = external_define(dll,"sxfmod_channel_set3DAttributes",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_get3DAttributes = external_define(dll,"sxfmod_channel_get3DAttributes",dll_cdecl,ty_string,2,ty_real,ty_real);
dll_sxfmod_channel_set3DMinMaxDistance = external_define(dll,"sxfmod_channel_set3DMinMaxDistance",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_channel_get3DMinMaxDistance = external_define(dll,"sxfmod_channel_get3DMinMaxDistance",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_set3DConeSettings = external_define(dll,"sxfmod_channel_set3DConeSettings",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_get3DConeSettings = external_define(dll,"sxfmod_channel_get3DConeSettings",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_set3DConeOrientation = external_define(dll,"sxfmod_channel_set3DConeOrientation",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_get3DConeOrientation = external_define(dll,"sxfmod_channel_get3DConeOrientation",dll_cdecl,ty_string,1,ty_real);
dll_sxfmod_channel_set3DOcclusion = external_define(dll,"sxfmod_channel_set3DOcclusion",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_channel_get3DOcclusion = external_define(dll,"sxfmod_channel_get3DOcclusion",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_set3DSpread = external_define(dll,"sxfmod_channel_set3DSpread",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_get3DSpread = external_define(dll,"sxfmod_channel_get3DSpread",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_addDSP = external_define(dll,"sxfmod_channel_addDSP",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_isPlaying = external_define(dll,"sxfmod_channel_isPlaying",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_isVirtual = external_define(dll,"sxfmod_channel_isVirtual",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_getAudibility = external_define(dll,"sxfmod_channel_getAudibility",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_getSpectrum = external_define(dll,"sxfmod_channel_getSpectrum",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_getIndex = external_define(dll,"sxfmod_channel_getIndex",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setMode = external_define(dll,"sxfmod_channel_setMode",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getMode = external_define(dll,"sxfmod_channel_getMode",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setLoopCount = external_define(dll,"sxfmod_channel_setLoopCount",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channel_getLoopCount = external_define(dll,"sxfmod_channel_getLoopCount",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channel_setLoopPoints = external_define(dll,"sxfmod_channel_setLoopPoints",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channel_getLoopPoints = external_define(dll,"sxfmod_channel_getLoopPoints",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
/*FMOD 'ChannelGroup' API*/
/*Not Currently Supported:
      dll_sxfmod_channelGroup_GetSystemObject
      dll_sxfmod_channelGroup_OverrideReverbProperties
      dll_sxfmod_channelGroup_GetGroup
      dll_sxfmod_channelGroup_GetDSPHead
      dll_sxfmod_channelGroup_GetName
      dll_sxfmod_channelGroup_GetChannel
      dll_sxfmod_channelGroup_GetWaveData
      dll_sxfmod_channelGroup_SetUserData
      dll_sxfmod_channelGroup_GetUserData
*/
dll_sxfmod_channelGroup_release = external_define(dll,"sxfmod_channelGroup_release",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channelGroup_setVolume = external_define(dll,"sxfmod_channelGroup_setVolume",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_getVolume = external_define(dll,"sxfmod_channelGroup_getVolume",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channelGroup_setPitch = external_define(dll,"sxfmod_channelGroup_setPitch",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_getPitch = external_define(dll,"sxfmod_channelGroup_getPitch",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channelGroup_stop = external_define(dll,"sxfmod_channelGroup_stop",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channelGroup_overridePaused = external_define(dll,"sxfmod_channelGroup_overridePaused",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_overrideVolume = external_define(dll,"sxfmod_channelGroup_overrideVolume",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_overrideFrequency = external_define(dll,"sxfmod_channelGroup_overrideFrequency",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_overridePan = external_define(dll,"sxfmod_channelGroup_overridePan",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_overrideMute = external_define(dll,"sxfmod_channelGroup_overrideMute",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_override3DAttributes = external_define(dll,"sxfmod_channelGroup_override3DAttributes",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channelGroup_overrideSpeakerMix = external_define(dll,"sxfmod_channelGroup_overrideSpeakerMix",dll_cdecl,ty_real,9,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_channelGroup_addGroup = external_define(dll,"sxfmod_channelGroup_addGroup",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_getNumGroups = external_define(dll,"sxfmod_channelGroup_getNumGroups",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channelGroup_addDSP = external_define(dll,"sxfmod_channelGroup_addDSP",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_channelGroup_getNumChannels = external_define(dll,"sxfmod_channelGroup_getNumChannels",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_channelGroup_getSpectrum = external_define(dll,"sxfmod_channelGroup_getSpectrum",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);

/*FMOD 'DSP' API*/
/*Not Currently Supported:
      dll_sxfmod_dsp_GetSystemObject()
      dll_sxfmod_dsp_AddInput()
      dll_sxfmod_dsp_DisconnectFrom()
      dll_sxfmod_dsp_GetInput()
      dll_sxfmod_dsp_GetOutput()
      dll_sxfmod_dsp_SetInputLevels()
      dll_sxfmod_dsp_GetInputLevels()
      dll_sxfmod_dsp_SetOutputLevels()
      dll_sxfmod_dsp_GetOutputLevels()
      dll_sxfmod_dsp_SetUserData()
      dll_sxfmod_dsp_GetUserData()
*/
dll_sxfmod_dsp_release = external_define(dll,"sxfmod_dsp_release",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_remove = external_define(dll,"sxfmod_dsp_remove",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_getNumInputs = external_define(dll,"sxfmod_dsp_getNumInputs",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_getNumOutputs = external_define(dll,"sxfmod_dsp_getNumOutputs",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_setInputMix = external_define(dll,"sxfmod_dsp_setInputMix",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_dsp_getInputMix = external_define(dll,"sxfmod_dsp_getInputMix",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_dsp_setOutputMix = external_define(dll,"sxfmod_dsp_setOutputMix",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_dsp_getOutputMix = external_define(dll,"sxfmod_dsp_getOutputMix",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_dsp_setActive = external_define(dll,"sxfmod_dsp_setActive",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_dsp_getActive = external_define(dll,"sxfmod_dsp_getActive",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_setBypass = external_define(dll,"sxfmod_dsp_setBypass",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_dsp_getBypass = external_define(dll,"sxfmod_dsp_getBypass",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_reset = external_define(dll,"sxfmod_dsp_reset",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_setParameter = external_define(dll,"sxfmod_dsp_setParameter",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
dll_sxfmod_dsp_getParameter = external_define(dll,"sxfmod_dsp_getParameter",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_dsp_getNumParameters = external_define(dll,"sxfmod_dsp_getNumParameters",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_getParameterInfo = external_define(dll,"sxfmod_dsp_getParameterInfo",dll_cdecl,ty_string,3,ty_real,ty_real,ty_real);
dll_sxfmod_dsp_showConfigDialog = external_define(dll,"sxfmod_dsp_showConfigDialog",dll_cdecl,ty_real,2,ty_real,ty_real);
dll_sxfmod_dsp_getInfo = external_define(dll,"sxfmod_dsp_getInfo",dll_cdecl,ty_string,2,ty_real,ty_real);
dll_sxfmod_dsp_getType = external_define(dll,"sxfmod_dsp_getType",dll_cdecl,ty_real,1,ty_real);
dll_sxfmod_dsp_setDefaults = external_define(dll,"sxfmod_dsp_setDefaults",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
dll_sxfmod_dsp_getDefaults = external_define(dll,"sxfmod_dsp_getDefaults",dll_cdecl,ty_real,2,ty_real,ty_real);

/*FMOD 'Geometry' API*/
/*Not Currently Implimented*/

/*WinAmp API*/
dll_sxwamp_init = external_define(dll,"sxwamp_init",dll_cdecl,ty_real,0);
dll_sxwamp_input_remove = external_define(dll,"sxwamp_input_remove",dll_cdecl,ty_real,0);
dll_sxwamp_output_remove = external_define(dll,"sxwamp_output_remove",dll_cdecl,ty_real,0);
dll_sxwamp_close = external_define(dll,"sxwamp_close",dll_cdecl,ty_real,0);
dll_sxwamp_input_load = external_define(dll,"sxwamp_input_load",dll_cdecl,ty_real,1,ty_string);
dll_sxwamp_output_load = external_define(dll,"sxwamp_output_load",dll_cdecl,ty_real,1,ty_string);
dll_sxwamp_stop = external_define(dll,"sxwamp_stop",dll_cdecl,ty_real,0);
dll_sxwamp_play = external_define(dll,"sxwamp_play",dll_cdecl,ty_real,1,ty_string);
dll_sxwamp_isPlaying = external_define(dll,"sxwamp_isPlaying",dll_cdecl,ty_real,0);
dll_sxwamp_setPaused = external_define(dll,"sxwamp_setPaused",dll_cdecl,ty_real,1,ty_real);
dll_sxwamp_getPaused = external_define(dll,"sxwamp_getPaused",dll_cdecl,ty_real,0);
dll_sxwamp_getLength = external_define(dll,"sxwamp_getLength",dll_cdecl,ty_real,0);
dll_sxwamp_getTime = external_define(dll,"sxwamp_getTime",dll_cdecl,ty_real,0);
dll_sxwamp_setTime = external_define(dll,"sxwamp_setTime",dll_cdecl,ty_real,1,ty_real);
dll_sxwamp_getVolume = external_define(dll,"sxwamp_getVolume",dll_cdecl,ty_real,0);
dll_sxwamp_setVolume = external_define(dll,"sxwamp_setVolume",dll_cdecl,ty_real,1,ty_real);
dll_sxwamp_setPan = external_define(dll,"sxwamp_setPan",dll_cdecl,ty_real,1,ty_real);
dll_sxwamp_getConfigure = external_define(dll,"sxwamp_getConfigure",dll_cdecl,ty_real,1,ty_real);
dll_sxwamp_getAbout = external_define(dll,"sxwamp_getAbout",dll_cdecl,ty_real,1,ty_real);
dll_sxwamp_getExtentions = external_define(dll,"sxwamp_getExtentions",dll_cdecl,ty_string,0);

/*Setup*/
return external_call(dll_init,window_handle(),argument1); /*,filename_change_ext(filename_name(parameter_string(0)),""));*/
#define sxms_close
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxms_close();
===
No Arguments
===
return = NULL
===
//Com:
      Use this to remove the sxms object and clear Game Maker memory usage
      of SXMS.
      
      If you used FMOD, make sure to cleanup before calling this function.
*/
with (sxms) { instance_destroy(); };
object_event_clear(sxms,ev_create,0);
object_event_clear(sxms,ev_destroy,0);
object_set_persistent(sxms,0);
object_set_visible(sxms,1);
return 0;
#define sxfmod_system_setCurrent
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setCurrent(fmodSystem);
===
argument0 = REAL - The FMOD system to use (0-2)
===
return = REAL - Wether successful (1) or failed (0)
===
//Com:
      Use this to switch which FMOD system all functions will
      deal with.  This includes the creating and releasing functions.
      So if you wanted to create a second FMOD system, use this to switch
      to another system then use the sxfmod_system_create function.
      
      Remember, all systems are independant of each other.  So things going
      on in one system do not effect another.
*/
return external_call(sxms.dll_sxfmod_system_setCurrent,argument0);
#define sxfmod_system_create
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxms_create();
===
No Arguments
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      This creates a system object.  A system object MUST be created before
      using any of fmod's abilites (including initialize).
      
      Multiple system objects can be made by using sxfmod_system_setCurrent
      to switch.  You can have up to three system objects running, but
      generally, only one is needed.
*/
return external_call(sxms.dll_sxfmod_system_create);
#define sxfmod_system_release
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_release();
===
No Arguments
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      This releases the current system object.  Once you do this, the system
      object is destroyed and cannot be used.  You can, however, create a
      new system object if needed.
      
      Note that this function automatically calls sxfmod_system_close to
      shutdown the FMOD system before releasing the object.
      
      Make sure to cleanup after yourself when your done using FMOD, as
      the sxms_close() script doesn't do this.
*/
return external_call(sxms.dll_sxfmod_system_release);
#define sxfmod_system_setOutput
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setOutput(sxms.FMOD_OUTPUTTYPE_);
===
argument0 = REAL - The output type to use:  FMOD_OUTPUTTYPE_
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      By default, sxfmod_system_init() autodetects the best choice.  You
      only need to call this if you want to force a selection, like
      WAVWRITER.
      
      FMOD_OUTPUTTYPE_UNKNOWN cannot be used for this function.
      
      If this isn't called, sxfmod_system_init() takes care of it for you.
      This can only be used before sxfmod_system_init() is called.
*/
return external_call(sxms.dll_sxfmod_system_setOutput,argument0);
#define sxfmod_system_getOutput
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getOutput();
===
No Arguments
===
return = REAL - The current output device, -1 if failed
===
//Com:
      This returns a numerical value of the current output device.
      The following are valid returns:
          FMOD_OUTPUTTYPE_UNKNOWN
          FMOD_OUTPUTTYPE_NOSOUND
          FMOD_OUTPUTTYPE_WAVWRITER
          FMOD_OUTPUTTYPE_DSOUND
          FMOD_OUTPUTTYPE_WINMM
          FMOD_OUTPUTTYPE_ASIO
*/
return external_call(sxms.dll_sxfmod_system_getOutput);
#define sxfmod_system_getNumDrivers
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getNumDrivers();
===
No Arguments
===
return = REAL - The number of drivers, or -1 if failed
===
//Com:
      Use this before selecting a driver (if you plan to select one).  As this
      will updated the internal enumerated list.
      (Basically, assigning each driver with a number value for referencing)
*/
return external_call(sxms.dll_sxfmod_system_getNumDrivers);
#define sxfmod_system_getDriverName
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getDriverName(driverIndex);
===
argument0 = REAL - The number or index of a driver
===
return = STRING - The string containing the name, or "" (blank) if failed
===
//Com:
      Make sure to use sxfmod_system_getNumDrivers() first.
*/
return external_call(sxms.dll_sxfmod_system_getDriverName,argument0);
#define sxfmod_system_getDriverCaps
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getDriverCaps(driverIndex,returnType);
===
argument0 = REAL - The number or index of a driver
argument1 = REAL - The type of returned information (0-3)
            0    - Capabilites of the driver:  FMOD_CAPS_
            1    - Minimum frequency
            2    - Maximum frequency
            3    - The current SpeakerMode:  FMOD_SPEAKERMODE_
===
return = REAL - Depends on argument1, -1 if failure
===
//Com:
      Since a driver can have multiple capabilites, you will need to check
      using the bitwise 'AND' operator for the return.
      
      Ex:  if (sxfmod_system_getDriver(0,0) & FMOD_CAPS_HARDWARE) { }
      
      That would check to see if the driver has hardware support.
*/
return external_call(sxms.dll_sxfmod_system_getDriverCaps,argument0,argument1);
#define sxfmod_system_setDriver
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setDriver(driverIndex);
===
argument0 = REAL - The index of a driver
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use sxfmod_system_getNumDrivers() first before selecting a driver.
      
      If this isn't called, sxfmod_system_init() takes care of it for you.
      This can only be used before sxfmod_system_init() is called.
*/
return external_call(sxms.dll_sxfmod_system_setDriver,argument0);
#define sxfmod_system_getDriver
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getDriver();
===
No Arguments
===
return = REAL - The index of the current driver, or -1 if failed
===
//Com:
      Used to get the currently set driver for output.
*/
return external_call(sxms.dll_sxfmod_system_getDriver);
#define sxfmod_system_setDSPBufferSize
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setDSPBufferSize(length,number);
===
argument0 = REAL - The length for all buffers (in SAMPLES, default is 512)
argument1 = REAL - The number of internal buffers (default 8)
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Lower values will decrease latency, but may cause choppy audio.
      Larger values may decrease choppiness, but increases latency.
      
      If this isn't called, sxfmod_system_init() takes care of it for you.
      This can only be used before sxfmod_system_init() is called.
*/
return external_call(sxms.dll_sxfmod_system_setDSPBufferSize,argument0,argument1);
#define sxfmod_system_getDSPBufferSize
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getDSPBufferSize(returnType);
===
argument0 = REAL - The type of return (0-1)
            0    - Buffer length (in SAMPLES)
            1    - The number of buffers
===
return = REAL - Depends on the argument, -1 if failed
===
//Com:
      Returns the current DSP buffer size and the number of buffers.
      Default is 512 SAMPLES with 8 buffers
*/
return external_call(sxms.dll_sxfmod_system_getDSPBufferSize,argument0);
#define sxfmod_system_setHardwareChannels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setHardwareChannels(min2D,max2D,min3D,max3D);
===
argument0 = REAL - The minimum 2D hardware channels
argument1 = REAL - The maximum 2D hardware channels
argument2 = REAL - The minimum 3D hardware channels
argument3 = REAL - The maximum 3D hardware channels
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      The minimumm values are the number of hardware channels a computer
      must support in order to use hardware.  If a computer doesn't have the
      minimum amount, FMOD will automatically go 100% software so users will
      still hear the sound but without any hardware acceleration.
      
      The maximum is used to set an FMOD limit.  Normally, FMOD will try to
      use all available hardware channels.  However, you can force FMOD
      to stay below a certian limit.
      
      If this isn't called, sxfmod_system_init() takes care of it for you.
      This can only be used before sxfmod_system_init() is called.
*/
return external_call(sxms.dll_sxfmod_system_setHardwareChannels,argument0,argument1,argument2,argument3);
#define sxfmod_system_getHardwareChannels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getHardwareChannels(returnType);
===
argument0 = REAL - The type of information returned
            0    - Number of 2D Hardware channels
            1    - Number of 3D Hardware channels
            2    - Total number of 2D and 3D channels
===
return = REAL - Depends on the argument, or -1 if failure.
===
//Com:
      You can use this function to determine the number of hardware channels
      available to you.  Note that when collecting the "total" number of
      hardware channels, this isn't the same as adding 3D and 2D.  So check
      the total, rather than adding the first to passes together.
*/
return external_call(sxms.dll_sxfmod_system_getHardwareChannels,argument0);
#define sxfmod_system_setSoftwareChannels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setSoftwareChannels(numberOfChannels);
===
argument0 = REAL - The number of software channels to set
===
return = REAL - 1 Successful, or 0 if failure.
===
//Com:
      Use this function to set the number of "software" channels to use.  If
      your not using software mixing, set this to 0.
      (by default, this is set to 32)
*/
return external_call(sxms.dll_sxfmod_system_setSoftwareChannels,argument0);
#define sxfmod_system_getSoftwareChannels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getSoftwareChannels();
===
No Arguments
===
return = REAL - The number of software channels, or -1 if failure.
===
//Com:
      This is used to get the total number of software channels.
*/
return external_call(sxms.dll_sxfmod_system_getSoftwareChannels);
#define sxfmod_system_setSoftwareFormat
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setSoftwareFormat(smapleRate,soundFormat,speakerNumber,maxChannel,sxms.FMOD_DSP_RESAMPLER_);
===
argument0 = REAL - The sample rate for the soundcard, default is 48000 (Hz)
argument1 = REAL - The type of sound format to use:  FMOD_SOUND_FORMAT_
argument2 = REAL - The number of channels/speakers to initialize the
                 - soundcard to.  Example: 1 = Mono, 2 = Stereo, etc.
                 - (default is 2)
argument3 = REAL - The maximum channel count in loaded/created sounds.
argument4 = REAL - The DSP resampler type:  FMOD_DSP_RESAMPLER_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This can be used to set the output format for the soundcard.
      These include the frequency (Hz), the bits per sample, and the number
      of channels/speakers.
      
      If this isn't called, sxfmod_system_init() takes care of it for you.
      This can only be used before sxfmod_system_init() is called.
*/
return external_call(sxms.dll_sxfmod_system_setSoftwareFormat,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_system_getSoftwareFormat
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getSoftwareFormat(returnType);
===
argument0 = REAL - The type of return information (0-3).
            0    - The current samplerate
            1    - A FMOD_SOUND_FORMAT_
            2    - Current number of channels/speakers
            3    - The maximum channel depth on sounds
            4    - The DSP resampler type
            5    - The bits per sample
===
return = REAL - Depends on the argument, -1 if failed.
===
//Com:
      The type of FMOD_SOUND_FORMATS that can be returned are:
          FMOD_SOUND_FORMAT_NONE
          FMOD_SOUND_FORMAT_PCM8
          FMOD_SOUND_FORMAT_PCM16
          FMOD_SOUND_FORMAT_PCM24
          FMOD_SOUND_FORMAT_PCM32
          FMOD_SOUND_FORMAT_PCMFLOAT
          
      The type of FMOD_DSP_RESAMPLERS that can be returned are:
          FMOD_DSP_RESAMPLER_NOINTERP
          FMOD_DSP_RESAMPLER_LINEAR
          FMOD_DSP_RESAMPLER_CUBIC
          FMOD_DSP_RESAMPLER_SPLINE 
*/
return external_call(sxms.dll_sxfmod_system_getSoftwareFormat,argument0);
#define sxfmod_system_setPluginPath
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setPluginPath(filepath);
===
argument0 = STRING - Path where FMOD plugins are stored
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This can be used to set the directory to load FMOD plugins from.  Mainly
      used before sxfmod_system_init() so the initialize function knows where
      to check for plugins.
*/
return external_call(sxms.dll_sxfmod_system_setPluginPath,argument0);
#define sxfmod_system_loadPlugin
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_loadPlugin(filename);
===
argument0 = STRING - Path and filename of a FMOD plugin to load.
===
return = REAL - The plugin index and type, or -1 if failed (check comments)
===
//Com:
      Use this function to load an external FMOD plugin.  The return value
      will be negative if fails, otherwise it will be a positive value.
      
      This function will update the sxms.array[] with the current plugin
      index and the plugin type.  So check this array after calling this
      function for those values.
      
      sxms.array[0] = Plugin Index
      sxms.array[1] = Plugin Type
      
      The type of plugins are:
      0 - Output Plugin
      1 - Codec Plugin
      2 - DSP Plugin
*/
var val; val = external_call(sxms.dll_sxfmod_system_loadPlugin,argument0);
if (val > 0) { sxms.array[0] = val div 10; sxms.array[1] = val mod 10; };
return val;
#define sxfmod_system_getNumPlugins
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getNumPlugins(sxms.FMOD_PLUGINTYPE_);
===
argument0 = REAL - The type of plugins to get number of:  FMOD_PLUGINTYPE_
===
return = REAL - The number of plugins for a certian type, or -1 if failure.
===
//Com:
      The return value is the number of current plugins.
*/
return external_call(sxms.dll_sxfmod_system_getNumPlugins,argument0);
#define sxfmod_system_getPluginInfo
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getPluginInfo(sxms.FMOD_PLUGINTYPE_,pluginIndex,returnType);
===
argument0 = REAL - The type of plugin:  FMOD_PLUGINTYPE_
argument1 = REAL - A plugin index to get info from
argument2 = REAL - The type of returned information
            0    - Plugin's Name
            1    - Plugin's Version
===
return = STRING - Depends on argument2, or "" (blank) if failure
===
//Com:
      The return value is either the plugin's name or it's version number,
      depending on the setting for argument2.
*/
return external_call(sxms.dll_sxfmod_system_getPluginInfo,argument0,argument1,argument2);
#define sxfmod_system_unloadPlugin
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_unloadPlugin(sxms.FMOD_PLUGINTYPE_,pluginIndex);
===
argument0 = REAL - The type of plugin:  FMOD_PLUGINTYPE_
argument1 = REAL - A plugin index to remove
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This will remove the selected plugin from the selected type.
*/
return external_call(sxms.dll_sxfmod_system_unloadPlugin,argument0,argument1);
#define sxfmod_system_setOutputByPlugin
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setOutputByPlugin(pluginIndex);
===
argument0 = REAL - The index of a loaded output plugin.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to select a output plugin for FMOD.  You must have previously
      loaded a plugin before it can be referenced by this function.
      
      If this isn't called, sxfmod_system_init() takes care of it for you.
      This can only be used before sxfmod_system_init() is called.
*/
return external_call(sxms.dll_sxfmod_system_setOutputByPlugin,argument0);
#define sxfmod_system_getOutputByPlugin
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getOutputByPlugin();
===
No Arguments
===
return = REAL - The index of the current output plugin.
===
//Com:
      This returns the current FMOD output plugin index.
*/
return external_call(sxms.dll_sxfmod_system_getOutputByPlugin);
#define sxfmod_system_init
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_init(maxChannels,sxms.FMOD_INIT_,projectHandle);
===
argument0 = REAL - The maximum channels (including virtual)
argument1 = REAL - Any additional flags, multiple may be passed:  FMOD_INIT_
argument2 = REAL - (optional) The handle to your project, 0 to ignore
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Argument0 is the number of channels total.  This means, the number of
      sounds you can play before channel cutting or stealing occurs.
      
      For the last argument, you can send the handle of your game to the
      dll so it will know when your game is in focus.
      
      This function is required before using most other functions.
*/
return external_call(sxms.dll_sxfmod_system_init,argument0,argument1,argument2);
#define sxfmod_system_close
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_close();
===
No Arguments
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This will close down the FMOD system.  However, the FMOD system object
      will remain for later use.  If you want to free the system object, use
      sxfmod_system_release().
*/
return external_call(sxms.dll_sxfmod_system_close);
#define sxfmod_system_update
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_update();
===
No Arguments
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      When making changes, you should call this function to update FMOD.
      If using non-realtime, it is required that you run this script once
      a step or whenever you want to update FMOD.
*/
return external_call(sxms.dll_sxfmod_system_update);
#define sxfmod_system_setSpeakerMode
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setSpeakerMode(sxms.FMOD_SPEAKERMODE_);
===
argument0 = REAL - The type of speaker mode:  FMOD_SPEAKERMODE_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This allows you to change the current speaker mode FMOD uses.
*/
return external_call(sxms.dll_sxfmod_system_setSpeakerMode,argument0);
#define sxfmod_system_getSpeakerMode
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getSpeakerMode();
===
No Arguments
===
return = REAL - The current speaker mode, or -1 if failure.
===
//Com:
      You can use this to get the current speaker mode setup FMOD is using.
      Use the FMOD_SPEAKERMODE_ constants for checking.
*/
return external_call(sxms.dll_sxfmod_system_getSpeakerMode);
#define sxfmod_system_setSpeakerPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setSpeakerPosition(sxms.FMOD_SPEAKER_,horizontal,vertical);
===
argument0 - REAL - The speaker to set position:  FMOD_SPEAKER_
argument1 - REAL - The X or left/right position, relative to user
argument2 - REAL - The Y or forward/backward position, relative to user
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This allows you to set "where" a certian speaker type is placed
      relative to the user.  Example, if a front left speaker is actually
      behind where the user is currently sitting, you can set that.
      
      argument1 works similar to panning, where a negative value means the
      speaker is left of the user while a positive value means the speaker
      is to the right of the user. (-1.0 to 1.0)
      
      For argument2, a negative value means the speaker is behind the user
      while a positive value means the speaker is infront of the user.
      (-1.0 to 1.0)
*/
return external_call(sxms.dll_sxfmod_system_setSpeakerPosition,argument0,argument1,argument2);
#define sxfmod_system_getSpeakerPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getSpeakerPosition(sxms.FMOD_SPEAKER_,returnType);
===
argument0 - REAL - The speaker to get position:  FMOD_SPEAKER_
argument1 - REAL - The type of return
            0    - Returns the X or left/right position
            1    - Returns the Y or forward/backward position
===
return = REAL - Depends on argument1, or -255 if failure.
===
//Com:
      This returns the position of the select speaker.
*/
return external_call(sxms.dll_sxfmod_system_getSpeakerPosition,argument0,argument1);
#define sxfmod_system_set3DSettings
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_set3DSettings(dopplerScale,distance,rolloff);
===
argument0 = REAL - Doppler scale amount
argument1 = REAL - Distance factor
argument2 = REAL - Rolloff Scale
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      argument0 is the scaling factor for the doppler shift.  Default value
      is 1.0.  Doppler is the pitch bending effect when a sound comes towards
      the listener or moves away from it, much like the effect you hear when
      a train goes past you with it's horn sounding.  FMOD's effective speed
      of sound at a doppler factor of 1.0 is 340 m/s.
      
      argument1 is the distance factor relative to FMOD's units.  Default
      value is 1.0 (1.0 = 1 meter).  This only effects dopplor.
      
      argument2 is the rolloff or attenuation for 3D sound.  Default is 1.0.
      This effects how fast sound drops off.
*/
return external_call(sxms.dll_sxfmod_system_set3DSettings,argument0,argument1,argument2);
#define sxfmod_system_get3DSettings
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_get3DSettings(returnType);
===
argument0 = REAL - The type of returned information
            0    - The doppler scale
            1    - The distance factor
            2    - The rolloff scale
===
return = REAL - Depends on the argument, or -255 if failure.
===
//Com:
      Returns the current 3D settings according to the argument.
*/
return external_call(sxms.dll_sxfmod_system_get3DSettings,argument0);
#define sxfmod_system_set3DNumListeners
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_set3DNumListeners(number);
===
argument0 = REAL - The number of listeners in the 3D space.  Defualt is 1.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This can be used to set multiple listeners (Example, in a spilt view
      type game where there may be multiple players).
*/
return external_call(sxms.dll_sxfmod_system_set3DNumListeners,argument0);
#define sxfmod_system_get3DNumListeners
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_get3DNumListeners();
===
No Arguments
===
return = REAL - The number of current 3D listeners, or -1 if failure
===
//Com:
      This returns the current number of 3D listeners.
*/
return external_call(sxms.dll_sxfmod_system_get3DNumListeners);
#define sxfmod_system_setStreamBufferSize
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setStreamBufferSize(bufferSize,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - The file buffer size.
argument1 = REAL - File buffer size time unit:  FMOD_TIMEUNIT_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This can be used to change the buffer sizes for streams.
      
      Note:  This doesn't effect streams that were created with the
      FMOD_OPENUSER flag.  Also, this function doesn't affect latency
      in playback.  All streams are pre-buffered before play.
*/
return external_call(sxms.dll_sxfmod_system_setStreamBufferSize,argument0,argument1);
#define sxfmod_system_getStreamBufferSize
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getStreamBufferSize(returnType);
===
argument0 = REAL - The type of return information
            0    - The file buffer size
            1    - The file buffer size time unit
===
return = REAL - Depends on the argument, or -1 if failure.
===
//Com:
      Use the argument to specify which type of information to return.
      
      Also, when getting a buffer size, make sure to get it's time unit type.
      FMOD_TIMEUNIT_
*/
return external_call(sxms.dll_sxfmod_system_getStreamBufferSize,argument0);
#define sxfmod_system_createSound
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_createSound(filename,sxms.FMOD_,extendedInfo,soundIndex);
===
argument0 = STRING - The filepath and name of a file to load.
argument1 = REAL   - Any extended flags for the loaded file:  FMOD_
argument2 = REAL   - Use FMOD_CREATESOUNDEXINFO (1) or not (0)
argument3 = REAL   - The index for the loaded sound (0-255)
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This is for loading a sound into FMOD.  Every type of sound you want
      to load in (be it stream, CD, sound effects or module) uses this
      function.  Make sure to assign your loaded sound with an index so
      you can later play, stop and free the audio.
      
      For argument1, mutiple flags can be set.  Seperate using the | symbol.
      Also, for larger files, it is highly recommend that you use streaming.
      (streaming also supports sequenced files like mod or midi).
      
      Argument2 allows you to send extended information when creating a sound.
      To do this, you must fill in the FMOD_CREATESOUNDEXINFO array conatined
      in the sxms object.  There are 18 members in total, which I will outline
      below.
      
      sxms.FMOD_CREATESOUNDEXINFO[0] Size Of Structure, FILLED IN BY SXMS
      sxms.FMOD_CREATESOUNDEXINFO[1] REAL - Length
      sxms.FMOD_CREATESOUNDEXINFO[2] REAL - File Offset
      sxms.FMOD_CREATESOUNDEXINFO[3] REAL - NumChannels
      sxms.FMOD_CREATESOUNDEXINFO[4] REAL - Default Frequency
      sxms.FMOD_CREATESOUNDEXINFO[5] FMOD_SOUND_FORMAT - Format
      sxms.FMOD_CREATESOUNDEXINFO[6] REAL - Decode Buffersize
      sxms.FMOD_CREATESOUNDEXINFO[7] REAL - Initial Subsound
      sxms.FMOD_CREATESOUNDEXINFO[8] REAL - NumSubSounds
      sxms.FMOD_CREATESOUNDEXINFO[9] STRING - Inclusion List
      sxms.FMOD_CREATESOUNDEXINFO[10] REAL - Inclusion List Number
      sxms.FMOD_CREATESOUNDEXINFO[11] FMOD_SOUND_PCMREADCALLBACK - PCM Read Callback
      sxms.FMOD_CREATESOUNDEXINFO[12] FMOD_SOUND_PCMSETPOSTCALLBACK - PCM Post Callback
      sxms.FMOD_CREATESOUNDEXINFO[13] FMOD_SOUND_NONBLOCKINGCALLBACK - NonBlocking Callback
      sxms.FMOD_CREATESOUNDEXINFO[14] STRING - DSL / SF2 filename
      sxms.FMOD_CREATESOUNDEXINFO[15] STRING - Encryption Key
      sxms.FMOD_CREATESOUNDEXINFO[16] REAL - MaxPolyPhony
      sxms.FMOD_CREATESOUNDEXINFO[17] VOID - UserData (Not Supported)
      
      Check the Fmod Documentation under FMOD_CREATESOUNDEXINFO for more
      indepth information on these parameters.
      
      For sxms.FMOD_CREATESOUNDEXINFO[9], you will need to send the list
      as a string in the form of "2|4|5|7".  Basically, the subsounds you
      want, each seperated by a pipe symbol.
      
      If you want to ignore a member, just enter a 0 (or "" if string) for
      the specified member.
*/
if (argument2) {
   external_call(sxms.dll_sxfmod_CREATESOUNDEXINFO1,sxms.FMOD_CREATESOUNDEXINFO[14],sxms.FMOD_CREATESOUNDEXINFO[15],sxms.FMOD_CREATESOUNDEXINFO[9]+"|");
   external_call(sxms.dll_sxfmod_CREATESOUNDEXINFO2,sxms.FMOD_CREATESOUNDEXINFO[3],sxms.FMOD_CREATESOUNDEXINFO[4],sxms.FMOD_CREATESOUNDEXINFO[5],sxms.FMOD_CREATESOUNDEXINFO[6],sxms.FMOD_CREATESOUNDEXINFO[7],sxms.FMOD_CREATESOUNDEXINFO[8],sxms.FMOD_CREATESOUNDEXINFO[10],sxms.FMOD_CREATESOUNDEXINFO[11],sxms.FMOD_CREATESOUNDEXINFO[12],sxms.FMOD_CREATESOUNDEXINFO[13],sxms.FMOD_CREATESOUNDEXINFO[16]);
   external_call(sxms.dll_sxfmod_CREATESOUNDEXINFO3,sxms.FMOD_CREATESOUNDEXINFO[1],sxms.FMOD_CREATESOUNDEXINFO[2]);
};
return external_call(sxms.dll_sxfmod_system_createSound,argument0,argument1,argument2,argument3);
#define sxfmod_system_createDSPByType
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_createDSPByType(sxms.FMOD_DSP_TYPE_,DSPIndex);
===
argument0 = REAL - The type of DSP to create:  FMOD_DSP_TYPE_
argument1 = REAL - An index number for the created DSP
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This function is used to create a "pre-built" DSP type.  When selecting
      a type, you should use the FMOD_DSP_TYPE_ constants avaliable.
      
      For argument1, assign this created DSP an index so that it can be
      referenced and cleared. 
*/
return external_call(sxms.dll_sxfmod_system_createDSPByType,argument0,argument1);
#define sxfmod_system_createDSPByIndex
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_createDSPByIndex(pluginIndex,DSPIndex);
===
argument0 = REAL - The plugin index
argument1 = REAL - An index number for the created DSP
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      When you load a plugin via sxfmod_system_loadPlugin, you can turn it
      into a DSP by passing the plugin's index to this function.
      
      The second argument is the index to set the created DSP on. 
*/
return external_call(sxms.dll_sxfmod_system_createDSPByIndex,argument0,argument1);
#define sxfmod_system_createChannelGroup
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_createChannelGroup(groupIndex);
===
argument0 = REAL - Index value for the channel group (0 to 255).
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this function to create a channel group.  After creation, you can
      assign channels to this group.  Any channel assigned to a channel
      group are effected by anything the channel group is.
      
      (example, attaching a DSP to the group effects all channels associated
      to the group). 
*/
return external_call(sxms.dll_sxfmod_system_createChannelGroup,argument0);
#define sxfmod_system_playSound
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_playSound(soundIndex,channel,pause);
===
argument0 = REAL - Index of a loaded sound to play.
argument1 = REAL - The channel to play on (or FMOD_CHANNEL_FREE/REUSE)
argument2 = REAL - Whether to start paused (1) or not (0)
===
return = REAL - The channel 'handle' the sound is being played on,
              - or -1 if failure.
===
//Com:
      This is used to play your loaded sounds.  The sound index must be of a
      loaded or existing sound in FMOD.
      
      You can start the audio paused to do any additional audio settings
      to the sound before playing.  Otherwise, just leave 0.
      
      This also allows you to select which channel to play on (from 0 to
      maxchannels - 1) or the flags FMOD_CHANNEL_FREE (which has Fmod do
      channel management for you) or FMOD_CHANNEL_REUSE. 
      
      The return is the channel 'handle' that the sound is playing on.  You
      can use this channel 'handle' in the sxfmod_channel_ functions.
*/
return external_call(sxms.dll_sxfmod_system_playSound,argument0,argument1,argument2);
#define sxfmod_system_playDSP
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_playDSP(DSPIndex,channel,pause);
===
argument0 = REAL - Index of a created DSP to play.
argument1 = REAL - The channel to play on (or FMOD_CHANNEL_FREE/REUSE)
argument2 = REAL - Whether to start paused (1) or not (0)
===
return = REAL - The channel 'handle' the sound is being played on,
              - or -1 if failure.
===
//Com:
      This is used to play your created DSP's.  The DSP index must be of an
      existing DSP in FMOD.  This is mainly used for DSP's which generate
      audio rather than take in audio for manipulation.
      
      You can start the audio paused to do any additional audio settings
      to the sound before playing.  Otherwise, just leave 0.
      
      This also allows you to select which channel to play on (from 0 to
      maxchannels - 1) or the flags FMOD_CHANNEL_FREE (which has Fmod do
      channel management for you) or FMOD_CHANNEL_REUSE. 
      
      The return is the channel 'handle' that the DSP is playing on.  You
      can use this channel 'handle' in the sxfmod_channel_ functions.
*/
return external_call(sxms.dll_sxfmod_system_playDSP,argument0,argument1,argument2);
#define sxfmod_system_getChannel
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getChannel(channel);
===
argument0 = REAL - A channel to get a channel handle from.
===
return = REAL - The channel 'handle' used for a specifc channel.
===
//Com:
      If you know the physical channel a sound is playing on, you can use
      this function to get the channel 'handle'.
      
      Normally, all sounds played will return a channel handle, so you
      shouldn't need to call this function.
*/
return external_call(sxms.dll_sxfmod_system_getChannel,argument0);
#define sxfmod_system_addDSP
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_addDSP(DSPIndex);
===
argument0 = REAL - The index of a DSP to add
===
return = REAL - Successful (1) or Failure (0)
===
//Com:
      This function attaches a DSP to the entire system.
      
      All output will be effected, if you want just a single channel
      to be effected, use sxfmod_channel_addDSP()
*/
return external_call(sxms.dll_sxfmod_system_addDSP,argument0);
#define sxfmod_system_getVersion
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getVersion();
===
No Arguments
===
return = REAL - Returns the current version of FMOD being used.
===
//Com:
      This returns the current FMOD version being used (in decimal form).
      
      Try to make sure your using the correct scripts with the correct
      FMOD Ex DLL version.
*/
return external_call(sxms.dll_sxfmod_system_getVersion);
#define sxfmod_system_getChannelsPlaying
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getChannelsPlaying();
===
No Arguments
===
return = REAL - The number of currently playing channels, or -1 if failure
===
//Com:
      This can be used to get the number of channels currently playing audio.
*/
return external_call(sxms.dll_sxfmod_system_getChannelsPlaying);
#define sxfmod_system_getCPUUsage
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getCPUUsage(returnType);
===
argument0 = REAL - The type of returned information
            0    - CPU usage for DSP's
            1    - CPU usage for streaming
            2    - CPU usage for updating
            3    - Total CPU usage
===
return = REAL - Depends on the argument, or -1 if failure.
===
//Com:
      Use this to get the amount of CPU is being taken to run FMOD.  Note, this
      does NOT include Game Maker's process, that would be added onto what
      FMOD is taking.
      
      The argument allows you to check specific area's for CPU usage or you
      can get the total amount for the entire FMOD process.
      
      The return value is from 0.0 to 100.0  (0% to 100%)
*/
return external_call(sxms.dll_sxfmod_system_getCPUUsage,argument0);
#define sxfmod_system_getNumCDROMDrives
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getNumCDROMDrives();
===
No Arguments
===
return = REAL - The number of CDROM drives available, or -1 if failure
===
//Com:
      Returns the number of CDROM drives.
*/
return external_call(sxms.dll_sxfmod_system_getNumCDROMDrives);
#define sxfmod_system_getCDROMDriveName
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getCDROMDriveName(driveIndex,returnType);
===
argument0 = REAL - The number index of the drive
argument1 = REAL - The type of returned information
            0    - The name of the CDROM drive
            1    - The SCSI address of the drive
            2    - The name of the physical device
===
return = STRING - Depends on argument1, or -1 if failure
===
//Com:
      This can be used to get various data about a CDROM drive.  Including
      its name, SCSI address and physical device name.
      
      The physical device name is usually a string that was defined by the
      manufacturer.  It contians the vendor ID, product ID and version
      number.
      
      Before using this function, use sxfmod_system_getNumCDROMDrives().
      This is so you don't try to pick a non-existant drive.
*/
return external_call(sxms.dll_sxfmod_system_getCDROMDriveName,argument0,argument1);
#define sxfmod_system_getSpectrum
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getSpectrum(size,channelOffset,sxms.FMOD_DSP_FFT_WINDOW_);
===
argument0 = REAL - The total number of slot values (size of array)
argument1 = REAL - The channel offset (for example, stereo streams)
argument2 = REAL - The FFT window type  FMOD_DSP_FFT_WINDOW_
===
return = NULL
===
//Com:
      This can be used to get visual or spectrial analysis from all currently
      playing audio.
      
      argument0 is the total number of slots.  The larger the array, the more
      "detailed" the returned information (since the audio signal is spread
      out over the entire array).  The lowest you can set is 64 and must be
      in powers of 2 (Ex:  64, 128, 256, 512, etc).  The maximum setting is
      8192.
      
      argument1 allows you to select which sound channel in a multi sound
      audio (like stereo).  Use 0 to get the "left", and 1 to get the "right"
      speaker.  In audio that supports more sound channels, you can get
      those independantly as well. 
      
      argument2 is the type of automatic windowing.  Use
      FMOD_DSP_FFT_WINDOW_RECT for no windowing. 
      
      This function is system wide. So use this if you want to get the
      entire system spectrum, rather than individual channels/sounds.
      
      Note:  This function only pulls the data from the audio and stores it
      into an array in the DLL.  To actually obtain the values, use
      sxfmod_getSpectrum() after this call. 
*/
return external_call(sxms.dll_sxfmod_system_getSpectrum,argument0,argument1,argument2);
#define sxfmod_system_getSpectrumStereo
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getSpectrumStereo(size,sxms.FMOD_DSP_FFT_WINDOW_);
===
argument0 = REAL - The total number of slot values (size of array)
argument1 = REAL - The FFT window type  FMOD_DSP_FFT_WINDOW_
===
return = NULL
===
//Com:
      This can be used to get visual or spectrial analysis from all currently
      playing audio.
      
      This works just like sxfmod_system_getSpectrum except the channel offset
      cannot be specified.  It's designed to pull both left and right
      sound channels and place them together into a single array.
      
      (Basically, this mimics the "old way" SXMS2 did it's spectrum anaylsis)
      
      Note:  This function only pulls the data from the audio and stores it
      into an array in the DLL.  To actually obtain the values, use
      sxfmod_getSpectrum() after this call. 
*/
return external_call(sxms.dll_sxfmod_system_getSpectrumStereo,argument0,argument1);
#define sxfmod_system_setRecordDriver
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setRecordDriver(driverIndex);
===
argument0 = REAL - The index of a recording driver
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to set what the recording driver is.  You should use
      sxfmod_system_getRecordNumDrivers() before using this one.
*/
return external_call(sxms.dll_sxfmod_system_setRecordDriver,argument0);
#define sxfmod_system_getRecordDriver
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getRecordDriver();
===
No Arguments
===
return = REAL - The index of current recording driver, or -1 if failure
===
//Com:
      This returns the current recording driver in use.  You should use
      sxfmod_system_getRecordNumDrivers() before this one.
*/
return external_call(sxms.dll_sxfmod_system_getRecordDriver);
#define sxfmod_system_getRecordNumDrivers
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getRecordNumDrivers();
===
No Arguments
===
return = REAL - The number of recording drivers, or -1 if failure
===
//Com:
      Returns the total number of avaliable recording drivers.
*/
return external_call(sxms.dll_sxfmod_system_getRecordNumDrivers);
#define sxfmod_system_getRecordDriverName
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getrecordDriverName(driverIndex);
===
argument0 = REAL - The index of a recording driver.
===
return = STRING - The name of the driver, or "" (blank) if failure.
===
//Com:
      This returns the name of the selected driver.  You should use
      sxfmod_system_getRecordNumDrivers() before using this function.
*/
return external_call(sxms.dll_sxfmod_system_getRecordDriverName,argument0);
#define sxfmod_system_getRecordPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getRecordPosition();
===
No Arguments
===
return = REAL - The position of the "recording cursor", or -1 if failure.
===
//Com:
      You can use this to get the position of the "recording cursor".  You
      should be recording before using this function.
*/
return external_call(sxms.dll_sxfmod_system_getRecordPosition);
#define sxfmod_system_recordStart
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_recordStart(soundIndex,loop);
===
argument0 = REAL - The sound index to record into.
argument1 = REAL - Whether recording should loop when it hits the end of
                 - sound index.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This will start recording the current audio from the selected recording
      driver.  The recorded data will be stored in the sound index passed in
      argument0.
      
      If you want an "indefinate" recording, set the loop to 1 (or true).
      This will make the "recording cursor" go back to the beginning of
      the sound and continue recording.  This can be useful when you
      are just monitoring recorded data, rather than trying to capture it.
*/
return external_call(sxms.dll_sxfmod_system_recordStart,argument0,argument1);
#define sxfmod_system_recordStop
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_recordStop();
===
No Arguments
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      When your done recording, call this function.  All recording will be
      halted.
*/
return external_call(sxms.dll_sxfmod_system_recordStop);
#define sxfmod_system_isRecording
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_isRecording();
===
No Arguments
===
return = REAL - Whether it's recording (1) or not (0), or -1 if failure.
===
//Com:
      This returns whether FMOD is currently recording or not.
*/
return external_call(sxms.dll_sxfmod_system_isRecording);
#define sxfmod_system_setNetworkProxy
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setNetworkProxy(proxy);
===
argument0 = STRING - The proxy server to use.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This is used to set the proxy server for all subsequent internal
      connections.
      
      The argument is a string and should use the following format:
      
      user:password@host:port
      (example) bob:sekrit123@www.fmod.org:8888
      
      If you don't need authentication, you can just use the host:port
      format.  (www.fmod.org:8888)
*/
return external_call(sxms.dll_sxfmod_system_setNetworkProxy,argument0);
#define sxfmod_system_getNetworkProxy
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getNetworkProxy();
===
No Arguments
===
return = STRING - The current proxy, or "" (blank) if failure.
===
//Com:
      This returns the current proxy used by FMOD.
      
      The return is a string with the following format:
      
      user:password@host:port
      (example) bob:sekrit123@www.fmod.org:8888
      
      If there is no authentication support, then it will just return
      the host:port
*/
return external_call(sxms.dll_sxfmod_system_getNetworkProxy);
#define sxfmod_system_setNetworkTimeout
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_setNetworkTimeout(milliseconds);
===
argument0 = REAL - Length of timeout in milliseconds
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This is used to set the internal timeout length used by Fmod when
      dealing with network streems.
*/
return external_call(sxms.dll_sxfmod_system_setNetworkTimeout,argument0);
#define sxfmod_system_getNetworkTimeout
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_system_getNetworkTimeout();
===
No Arguments
===
return = REAL - The length of timeout in milliseconds, or -1 if failed.
===
//Com:
      Returns the length of the timeout when dealing with network streams.
      A -1 is returned if a failure occurred
*/
return external_call(sxms.dll_sxfmod_system_getNetworkTimeout);
#define sxfmod_sound_release
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_release(soundIndex);
===
argument0 = REAL - A sound index.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to free or release a sound from FMOD.  Once a sound is released
      it cannot be played or used.
*/
return external_call(sxms.dll_sxfmod_sound_release,argument0);
#define sxfmod_sound_setDefaults
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_setDefaults(soundIndex,freq,vol,pan,pri);
===
argument0 = REAL - A sound index.
argument1 = REAL - The default frequency
argument2 = REAL - The default volume
argument3 = REAL - The default pan setting
argument4 = REAL - The default priority
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This is used to set some default information about a sound.  Example,
      instead of always setting a sound's volume every time you play it, you
      can make it have a pre-defined volume which it will automatically
      use every time you play that sound.
*/
return external_call(sxms.dll_sxfmod_sound_setDefaults,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_sound_getDefaults
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getDefaults(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of returned information
            0    - frequency
            1    - volume
            2    - pan setting
            3    - priority
===
return = REAL - Depends on argument1, or -2 if failure
===
//Com:
      Used to get the default settings of a sound.  Use argument1 to
      determine which type of information you want returned.
*/
return external_call(sxms.dll_sxfmod_sound_getDefaults,argument0,argument1);
#define sxfmod_sound_setVariations
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_setVariations(soundIndex,freq,vol,pan);
===
argument0 = REAL - A sound index.
argument1 = REAL - The frequency variation.
argument2 = REAL - The volume variation.
argument3 = REAL - The panning variation.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      (BETA NOTE):  I honestly have no idea what this function does at the
      moment (it's undocumented by FMOD).  This should be resolved in the near
      future.
      
      If this is the final release of SXMS and your seeing this note, tell
      me right away so I can fix it.
*/
return external_call(sxms.dll_sxfmod_sound_setVariations,argument0,argument1,argument2,argument3);
#define sxfmod_sound_getVariations
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getVariations(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of returned information
            0    - The frequency variation
            1    - The volume variation
            2    - The panning variation
===
return = REAL - Depends on argument1, or -2 if failure
===
//Com:
      (BETA NOTE):  I honestly have no idea what this function does at the
      moment (it's undocumented by FMOD).  This should be resolved in the near
      future.
      
      If this is the final release of SXMS and your seeing this note, tell
      me right away so I can fix it.
*/
return external_call(sxms.dll_sxfmod_sound_getVariations,argument0,argument1);
#define sxfmod_sound_set3DMinMaxDistance
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_set3DMinMaxDistance(soundIndex,min,max);
===
argument0 = REAL - A sound index.
argument1 = REAL - The min distance.
argument2 = REAL - The max distance.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Used to set the 3D min/max distance for the sound.
*/
return external_call(sxms.dll_sxfmod_sound_set3DMinMaxDistance,argument0,argument1,argument2);
#define sxfmod_sound_get3DMinMaxDistance
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_get3DMinMaxDistance(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of information returned
            0    - The minimum distance
            1    - The maximum distance
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      Used to get the Min/Max distance set to a sound.
*/
return external_call(sxms.dll_sxfmod_sound_get3DMinMaxDistance,argument0,argument1);
#define sxfmod_sound_set3DConeSettings
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_set3DConeSettings(soundIndex,insideAngle,outsideAngle,vol);
===
argument0 = REAL - A sound index.
argument1 = REAL - The inside cone angle.
argument2 = REAL - The outside cone angle.
argument3 = REAL - The outside volume
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Allows you to set the inside and outside angles of a sound projection
      cone, as well as the volume of the sound outside the outside angle of
      the sound cone.
      
      arguments1-2 are measured in degrees (0-360)
      
      argument3 is a volume from 0.0 to 1.0 (none to full)
*/
return external_call(sxms.dll_sxfmod_sound_set3DConeSettings,argument0,argument1,argument2,argument3);
#define sxfmod_sound_get3DConeSettings
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_get3DConeSettings(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of returned information
            0    - Inside cone angle
            1    - Outside cone angle
            2    - Outside volume
===
return = REAL - Depends on argument1, or -1 if failure
===
//Com:
      This is used to get the 3DConeSettings for the specified sound.
*/
return external_call(sxms.dll_sxfmod_sound_get3DConeSettings,argument0,argument1);
#define sxfmod_sound_setSubSound
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_setSubSound(parentSoundIndex,subSound,soundIndex);
===
argument0 = REAL - A sound index.
argument1 = REAL - The index to set as the sub sound
argument2 = REAL - A sound index (the sub sound)
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Allows you to place a sound as part of another sound (or subsound).
      (Think of it as a sound within a sound)
      
      The first argument is the 'parent' sound, or the sound which will
      hold the sub sound.
      
      You then need to set an index which will identify the sub sound.
      
      The last argumnet is the sound index of a 'child' sound, or the sound
      which will be added as a sub sound.
*/
return external_call(sxms.dll_sxfmod_sound_setSubSound,argument0,argument1,argument2);
#define sxfmod_sound_getSubSound
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getSubSound(parentSoundIndex,subSound,soundIndex);
===
argument0 = REAL - The 'parent' sound index.
argument1 = REAL - The sub sound index to get
argument2 = REAL - A sound index to store the sub sound into
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This allows you to get a sub sound and store it as its own sound.
      You will need to pass the parent sound (or the sound holding sub sounds)
      and you will need to pass which subsound you want to collect.
      
      The last argument is the sound index to store the sub sound in.
*/
return external_call(sxms.dll_sxfmod_sound_getSubSound,argument0,argument1,argument2);
#define sxfmod_sound_getName
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getName(soundIndex);
===
argument0 = REAL - A sound index.
===
return = STRING - The name of the sound, or "" (blank) if failure
===
//Com:
      This can be used to get the name of a sound.  If a sound doesn't contain
      an internal name, FMOD should (I'm assuming here) return the filename
      instead.
*/
return external_call(sxms.dll_sxfmod_sound_getName,argument0);
#define sxfmod_sound_getLength
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getLength(soundIndex,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A sound index.
argument1 = REAL - The time unit for the return:  FMOD_TIMEUNIT_
===
return = REAL - The length of the sound, or -1 if failure
===
//Com:
      This will return the length of the sound in whatever timeunit you
      specified.
*/
return external_call(sxms.dll_sxfmod_sound_getLength,argument0,argument1);
#define sxfmod_sound_getFormat
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getFormat(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of information to return.
            0    - File format:  FMOD_SOUND_TYPE_
            1    - Sound format:  FMOD_SOUND_FORMAT_
            2    - Number of 'sound channels' (1 = mono, 2 = stereo)
            3    - Number of bits per sample
===
return = REAL - Depends on argument1, or -1 if failure
===
//Com:
      This will return various format information about the specified
      sound.
*/
return external_call(sxms.dll_sxfmod_sound_getFormat,argument0,argument1);
#define sxfmod_sound_getNumSubSounds
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getNumSubSounds(soundIndex);
===
argument0 = REAL - A sound index.
===
return = REAL - Returns the number of sub sounds, or -1 if failure
===
//Com:
      This returns the number of sub sounds (if any) in the specified sound
      index.
*/
return external_call(sxms.dll_sxfmod_sound_getNumSubSounds,argument0);
#define sxfmod_sound_getNumTags
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getNumTags(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of returned information.
            0    - Total number of tags
            1    - The number of updated tags since last call
===
return = REAL - Depends on argument1, or -1 if failure
===
//Com:
      You can use this to get the number of internal tags in the specified
      sound.  If you wish to only get the number of "updated" tags since
      last checking, pass a 1 for argument1.
*/
return external_call(sxms.dll_sxfmod_sound_getNumTags,argument0,argument1);
#define sxfmod_sound_getTag
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getTag(soundIndex,tag,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The tag number to get.
argument2 = REAL - The type of information returned about the selected tag.
            0    - Tag type:  FMOD_TAGTYPE_
            1    - Tag data type:  FMOD_TAGDATATYPE_
            2    - Tag's title (Like "TITLE" or "ARTIST")
            3    - Tag's information (like "My Song" or "Mr. Jay")
            4    - Whether the tag has been updated since last check
===
return = STRING - Depends on argument2, or "" (blank) if failure
===
//Com:
      When checking the tag type, remember that the return is STRING.  So
      make sure to real the return before comparing against the
      FMOD_TAGTYPE constants.  This also goes for the tag data type.
      
      Note that if your checking if the tag was updated, do that first.
      Example, before pulling any other info, check the updated call.
      This is because if you call any other information, then check
      to see it was updated, it will always return FALSE since you
      pull other information previous to the updated check.
      
      The FMOD_TAGDATATYPE_ return isn't really important and more for just
      informational purposes.  The conversion to string is already taken
      care of via the SXMS-3.dll
*/
return external_call(sxms.dll_sxfmod_sound_getTag,argument0,argument1,argument2);
#define sxfmod_sound_getOpenState
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getOpenState(soundIndex,returnType);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of return information.
            0    - The open status:  FMOD_OPENSTATE_
            1    - Percent Buffered:
            2    - The starving state (read comments)
===
return = REAL - Depends on argument1, or -1 if failure
===
//Com:
      This allows you to check the current state of the indicated sound.  The
      starving state is when a stream has decoded more than the stream
      file buffer has ready for it.  If will return either TRUE or FALSE.
*/
return external_call(sxms.dll_sxfmod_sound_getOpenState,argument0,argument1);
#define sxfmod_sound_setMode
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_setMode(soundIndex,sxms.FMOD_);
===
argument0 = REAL - A sound index.
argument1 = REAL - The fmod mode to set:  FMOD_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      You can set various modes to a sound using this function.  Also, you
      can set multiple modes at once by seperating them using the | symbol.
*/
return external_call(sxms.dll_sxfmod_sound_setMode,argument0,argument1);
#define sxfmod_sound_getMode
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getMode(soundIndex);
===
argument0 = REAL - A sound index.
===
return = REAL - The modes set for the sound, or -1 if failure.
===
//Com:
      Since a sound can have multiple modes set to it, you will need to check
      the return using the bitwise 'AND' symbol.
      
      EX:  if (sxfmod_sound_getMode(0) & FMOD_LOOP_OFF) { }
      
      That would check to see if FMOD_LOOP_OFF was one of the returned
      modes.
*/
return external_call(sxms.dll_sxfmod_sound_getMode,argument0);
#define sxfmod_sound_setLoopCount
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_setLoopCount(soundIndex,number);
===
argument0 = REAL - A sound index.
argument1 = REAL - The number of times the sound should loop.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      You can set how many times a sound should loop before stopping by
      using this function.  This is the number of times it should loop.  So
      a 1 would make it loop once, while a setting of 0 would make it play
      and stop at end.  If you pass a -1, the sound will loop indefinately.
      (-1 is the default setting).
*/
return external_call(sxms.dll_sxfmod_sound_setLoopCount,argument0,argument1);
#define sxfmod_sound_getLoopCount
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getLoopCount(soundIndex);
===
argument0 = REAL - A sound index.
===
return = REAL - The sound's loop count, or -2 if failure.
===
//Com:
      This returns the current loop count set to the sound.  Remember that
      -1 means indefinate (don't mistake a -1 as an error)
*/
return external_call(sxms.dll_sxfmod_sound_getLoopCount,argument0);
#define sxfmod_sound_setLoopPoints
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_setLoopPoints(soundIndex,start,sxms.FMOD_TIMEUNIT_,end,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A sound index.
argument1 = REAL - The starting loop point
argument2 = REAL - The timeunit used for argument1:  FMOD_TIMEUNIT_
argument3 = REAL - The ending loop point
argument4 = REAL - The timeunit used for argument3:  FMOD_TIMEUNIT_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This can be used to set internal loop points to the sound.  Note that
      the very begining of audio is 0 while the end is always the length -1.
      
      Example, a 1000ms song's normal loop points are 0 and 999.
*/
return external_call(sxms.dll_sxfmod_sound_setLoopPoints,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_sound_getLoopPoints
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_sound_getLoopPoints(soundIndex,returnType,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A sound index.
argument1 = REAL - The type of information returned.
            0    - The starting loop point
            1    - The ending loop point
argument2 = REAL - The time method for the return:  FMOD_TIMEUNIT_
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      This can be used to obtain the loop points for a sound.  Make sure to
      specify a time unit.
*/
return external_call(sxms.dll_sxfmod_sound_getLoopPoints,argument0,argument1,argument2);
#define sxfmod_channel_stop
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_stop(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - Whether successful (1) of failed (0)
===
//Com:
      Use this to stop any audio on the specified channel.
*/
return external_call(sxms.dll_sxfmod_channel_stop,argument0);
#define sxfmod_channel_setPaused
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setPaused(channel,pause);
===
argument0 = REAL - A channel handle
argument1 = REAL - Whether to pause (1) or unpause (0)
===
return = REAL - Whether successful (1) of failed (0)
===
//Com:
      Set the channels pause state.
*/
return external_call(sxms.dll_sxfmod_channel_setPaused,argument0,argument1);
#define sxfmod_channel_setVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setVolume(channel,vol);
===
argument0 = REAL - A channel handle
argument1 = REAL - The volume of the channel (0.0 to 1.0)
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to set a channels volume.  The value is as a percent, or
      0.0 to 1.0 with 1.0 being full volume.
*/
return external_call(sxms.dll_sxfmod_channel_setVolume,argument0,argument1);
#define sxfmod_channel_getVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getVolume(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The channel's volume, or -1 if failure.
===
//Com:
      This will return the current channel's volume, it will be from 0.0 to 1.0
*/
return external_call(sxms.dll_sxfmod_channel_getVolume,argument0);
#define sxfmod_channel_setFrequency
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setFrequency(channel,freq);
===
argument0 = REAL - A channel handle
argument1 = REAL - The frequency for the channel.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      You can set a channels frequency (in Hz) using this function.  You can
      use negative frequencies to play a sound backwards.
      
      If sound is FMOD_SOFTWARE, then negative frequencies will only work for
      non-streamed sounds.
      
      If using FMOD_HARDWARE with DSOUND, there is a frequency range limit
      which is computer dependant.  If you try to set a setting outside this
      limit, than FMOD will pick the highest or lowest value within the
      allowable limit.  FMOD_SOFTWARE doesn't have this limitiation.
*/
return external_call(sxms.dll_sxfmod_channel_setFrequency,argument0,argument1);
#define sxfmod_channel_setPan
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setPan(channel,pan);
===
argument0 = REAL - A channel handle
argument1 = REAL - The pan setting
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Full left is -1.0, center is 0.0 and full right is 1.0.
*/
return external_call(sxms.dll_sxfmod_channel_setPan,argument0,argument1);
#define sxfmod_channel_getPan
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getPan(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The pan setting for the channel, or -2 if failure.
===
//Com:
      Full left is -1.0, center is 0.0 and full right is 1.0.
*/
return external_call(sxms.dll_sxfmod_channel_getPan,argument0);
#define sxfmod_channel_getFrequency
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getFrequency(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The channel's frequency, or 0 if failure.
===
//Com:
      The returned value is in (Hz).
*/
return external_call(sxms.dll_sxfmod_channel_getFrequency,argument0);
#define sxfmod_channel_getDelay
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getDelay(channel,returnType);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of returned information
            0    - Starting delay amount
            1    - Ending delay amount
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      This can be used to get a channel's delay lengths.  The returned times
      are in milliseconds.
*/
return external_call(sxms.dll_sxfmod_channel_getDelay,argument0,argument1);
#define sxfmod_channel_setSpeakerMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setSpeakerMix(channel,frontLeft,frontRight,center,low,backLeft,backRight,sideLeft,sideRight);
===
argument0 = REAL - A channel handle
argument1 = REAL - Front left speaker level
argument2 = REAL - Front right speaker level
argument3 = REAL - Center speaker level
argument4 = REAL - Low Frequency speaker level
argument5 = REAL - Back left speaker level
argument6 = REAL - Back right speaker level
argument7 = REAL - Side left speaker level
argument8 = REAL - Side right speaker level
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      (BETA NOTE):  I honestly have no idea what this function does at the
      moment (it's undocumented by FMOD).  This should be resolved in the near
      future.
      
      If this is the final release of SXMS and your seeing this note, tell
      me right away so I can fix it.
*/
return external_call(sxms.dll_sxfmod_channel_setSpeakerMix,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8);
#define sxfmod_channel_getSpeakerMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getSpeakerMix(channel,returnType);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of speaker levels to return
            0    - Front left
            1    - Front right
            2    - Center
            3    - Low Frequency
            4    - Back left
            5    - Back right
            6    - Side left
            7    - Side right
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      (BETA NOTE):  I honestly have no idea what this function does at the
      moment (it's undocumented by FMOD).  This should be resolved in the near
      future.
      
      If this is the final release of SXMS and your seeing this note, tell
      me right away so I can fix it.
*/
return external_call(sxms.dll_sxfmod_channel_getSpeakerMix,argument0,argument1);
#define sxfmod_channel_setSpeakerLevels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setSpeakerLevels(channel,sxms.FMOD_SPEAKER_,numberOfInputs,level0,level1,...);
===
argument0 = REAL - A channel handle
argument1 = REAL - The speaker to effect:  FMOD_SPEAKER_
argument2 = REAL - The number of channel inputs (ex: 1 = Mono, 2 = Stereo)
argument3-argument11 = REAL - The level of each input.
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      The number of input channels depends on the sound playing on the
      channel.  A mono sound uses 1, a stereo one uses 2, etc.
      For the following arguments (3-11), you specify the level of
      audio (0.0 to 1.0).  You only need to fill in the number of
      arguments for your inputs.  Example, for a mono sound, you only
      need to use argument3, in stereo, you need to use argument3 and 4.
*/
return external_call(sxms.dll_sxfmod_channel_setSpeakerLevels,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8,argument9,argument10,argument11);
#define sxfmod_channel_getSpeakerLevels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getSpeakerLevels(channel,sxms.FMOD_SPEAKER_,input);
===
argument0 = REAL - A channel handle
argument1 = REAL - The speaker to get:  FMOD_SPEAKER_
argument2 = REAL - The channel input to check.
===
return = REAL - The speaker level for the selected channel input
===
//Com:
      Once you pick which speaker, you also need to select which channel input
      to check.  Example, for a mono sample, you would pass a 0 to check the
      input channel.  For stereo, you would need to check 0 and 1.
*/
return external_call(sxms.dll_sxfmod_channel_getSpeakerLevels,argument0,argument1,argument2);
#define sxfmod_channel_setMute
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setMute(channel,mute);
===
argument0 = REAL - A channel handle
argument1 = REAL - Whether to mute (1) or unmute (0)
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      Allows you to mute or unmute a channel.
*/
return external_call(sxms.dll_sxfmod_channel_setMute,argument0,argument1);
#define sxfmod_channel_setDelay
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setDelay(channel,startDelay,endDelay);
===
argument0 = REAL - A channel handle
argument1 = REAL - The starting delay amount
argument2 = REAL - The ending delay amount
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      The start delay is the amount of time (in milliseconds) before the
      sound starts.  The ending delay is the amount of time after the sound
      has stopped before the channel stops processing.
      
      If you used sxfmod_channel_isPlaying() on a channel with a delay, it
      will return as TRUE while the delay is in progress.
*/
return external_call(sxms.dll_sxfmod_channel_setDelay,argument0,argument1,argument2);
#define sxfmod_channel_setPriority
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setPriority(channel,pri);
===
argument0 = REAL - A channel handle
argument1 = REAL - The channel's priority (0-256)
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to set a channels priority. A 0 has more priority than a 256.
*/
return external_call(sxms.dll_sxfmod_channel_setPriority,argument0,argument1);
#define sxfmod_channel_getMute
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getMute(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - Whether muted (1) or not (0), or -1 if failure.
===
//Com:
      Collects the mute state for the selected channel
*/
return external_call(sxms.dll_sxfmod_channel_getMute,argument0);
#define sxfmod_channel_getPriority
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getPriority(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The channels' priority, or -1 if failure.
===
//Com:
      Returns a channel's priority.
*/
return external_call(sxms.dll_sxfmod_channel_getPriority,argument0);
#define sxfmod_channel_setPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setPosition(channel,position,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A channel handle
argument1 = REAL - The position to set
argument2 = REAL - The time unit for the position:  FMOD_TIMEUNIT_
===
return = REAL - Whether successful (1) or failed (0).
===
//Com:
      Allows you to set what the current position of the channel's sound is.
*/
return external_call(sxms.dll_sxfmod_channel_setPosition,argument0,argument1,argument2);
#define sxfmod_channel_getPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getPosition(channel,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A channel handle
argument1 = REAL - The time unit for the position:  FMOD_TIMEUNIT_
===
return = REAL - The current position, or -1 if failure.
===
//Com:
      Returns the current position of the sound in the specified channel.
*/
return external_call(sxms.dll_sxfmod_channel_getPosition,argument0,argument1);
#define sxfmod_channel_setChannelGroup
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setChannelGroup(channel,group);
===
argument0 = REAL - A channel handle
argument1 = REAL - The handle to a channel group
===
return = REAL - 1 Successful, or 0 if failure
===
//Com:
      Sets the current channel into a channel group
*/
return external_call(sxms.dll_sxfmod_channel_setChannelGroup,argument0,argument1);
#define sxfmod_channel_set3DAttributes
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_set3DAttributes(channel,vectorType,x,y,z);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of vector
            0    - A position
            1    - A velocity
argument2 = REAL - The X value of a vector
argument3 = REAL - The Y value of a vector
argument4 = REAL - The Z value of a vector
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Allows you to set a position or velocity of a 3D channel.
*/
return external_call(sxms.dll_sxfmod_channel_set3DAttributes,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_channel_getPaused
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getPaused(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The pause state for the channel, or -1 if failure.
===
//Com:
      Returns the channel's current pause state
*/
return external_call(sxms.dll_sxfmod_channel_getPaused,argument0);
#define sxfmod_channel_set3DMinMaxDistance
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_set3DMinMaxDistance(channel,min,max);
===
argument0 = REAL - A channel handle
argument1 = REAL - The min value
argument2 = REAL - The max value
===
return = REAL - Whether successful (1) or failure (0).
===
//Com:
      Sets a minimum and maximum audible distance for a channel.
*/
return external_call(sxms.dll_sxfmod_channel_set3DMinMaxDistance,argument0,argument1,argument2);
#define sxfmod_channel_get3DMinMaxDistance
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_get3DMinMaxDistance(channel,returnType);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of returned information
            0    - The minimum value
            1    - The maximum value
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      Returns a minimum and maximum audible distance of a channel.
*/
return external_call(sxms.dll_sxfmod_channel_get3DMinMaxDistance,argument0,argument1);
#define sxfmod_channel_set3DConeSettings
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_set3DConeSettings(channel,insideAngle,outsideAngle,vol);
===
argument0 = REAL - A channel handle
argument1 = REAL - The inside cone angle
argument2 = REAL - The outside cone angle
argument3 = REAL - The outside volume
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Arguments1-2 are in degrees, with default being 360.  The outside
      volume is from 0.0 to 1.0.
*/
return external_call(sxms.dll_sxfmod_channel_set3DConeSettings,argument0,argument1,argument2,argument3);
#define sxfmod_channel_get3DConeSettings
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_get3DConeSettings(channel,returnType);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of returned information
            0    - Inside cone angle
            1    - Outside cone angle
            2    - Outside volume
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      Returns the inside/outside cone angle for the selected channel, along
      with it's outside volume.
*/
return external_call(sxms.dll_sxfmod_channel_get3DConeSettings,argument0,argument1);
#define sxfmod_channel_set3DConeOrientation
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_set3DConeOrientation(channel,x,y,z);
===
argument0 = REAL - A channel handle
argument1 = REAL - X of an orientation vector
argument2 = REAL - Y of an orientation vector
argument3 = REAL - Z of an orientation vector
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Sets the cone's orientation to the specified vector.
*/
return external_call(sxms.dll_sxfmod_channel_set3DConeOrientation,argument0,argument1,argument2,argument3);
#define sxfmod_channel_get3DConeOrientation
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_get3DConeOrientation(channel);
===
argument0 = REAL - A channel handle
===
return = STRING - A "X|Y|Z" vector, or "" (blank) if failure.
===
//Com:
      The returned vector is a STRING.  You will have to manually seperate the
      values.
      
      Example return:  "1.6|5.7|10.7"
*/
return external_call(sxms.dll_sxfmod_channel_get3DConeOrientation,argument0);
#define sxfmod_channel_set3DSpread
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_set3DSpread(channel,degrees);
===
argument0 = REAL - A channel handle
argument1 = REAL - The amount in degrees (0.0 to 360.0)
===
return = REAL - Successful (1) or Failed (0)
===
//Com:
      Set the spread of a sound, 0 means all channels are located at the same
      position while 360 means the opposite position...more indepth comments
      on this function in the Fmod Ex Manual 
*/
return external_call(sxms.dll_sxfmod_channel_set3DSpread,argument0,argument1);
#define sxfmod_channel_get3DSpread
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_get3DSpread();
===
argument0 = REAL - A channel handle
===
return = REAL - The amount of angle from 0.0 to 360.0
===
//Com:
      Get the amount of spread on a channel.
*/
return external_call(sxms.dll_sxfmod_channel_get3DSpread,argument0);
#define sxfmod_channel_addDSP
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_addDSP(channel,DSPIndex);
===
argument0 = REAL - A channel handle
argument1 = REAL - A DSP index to attach to channel
===
return = REAL - Successful (1) or failure (0)
===
//Com:
      This function is used to attach a created DSP onto a channel.
*/
return external_call(sxms.dll_sxfmod_channel_addDSP,argument0,argument1);
#define sxfmod_channel_isPlaying
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_isPlaying(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - Whether is playing (1) or not (0), or -1 if failure.
===
//Com:
      This returns whether the selected channel is currently playing any
      audio or not.
*/
return external_call(sxms.dll_sxfmod_channel_isPlaying,argument0);
#define sxfmod_channel_isVirtual
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_isVirtual(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - Whether is virtual (1) or not (0), or -1 if failure.
===
//Com:
      This returns whether the selected channel is currently a virtual channel.
*/
return external_call(sxms.dll_sxfmod_channel_isVirtual,argument0);
#define sxfmod_channel_getAudibility
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getAudibility(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The channel's audibility, or -1 if failure.
===
//Com:
      This returns the combined volume of the channel after 3D sound, volume,
      master volume an dgeometry occlusion calculations have been performed
      on it.
*/
return external_call(sxms.dll_sxfmod_channel_getAudibility,argument0);
#define sxfmod_channel_get3DAttributes
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_get3DAttributes(channel,returnType);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of vector
            0    - A position
            1    - A velocity
===
return = STRING - A "X|Y|Z" vector, or "" (blank) if failure.
===
//Com:
      This returns a STRING value with an X, Y, and Z componet of a vector.
      Each value is seperated by a | symbol.
      
      Ex:  "1.6|5.7|10.7"
      
      You'll need to seperate the values and make them real for comparison.
*/
return external_call(sxms.dll_sxfmod_channel_get3DAttributes,argument0,argument1);
#define sxfmod_channel_get3DOcclusion
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_get3DOcclusion(channel,returnType);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of information returned.
            0    - Direct Occlusion
            1    - Reverb Occlusion
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      Returns the occlusion values for the current channel.
*/
return external_call(sxms.dll_sxfmod_channel_get3DOcclusion,argument0,argument1);
#define sxfmod_channel_getSpectrum
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getSpectrum(channel,size,channelOffset,sxms.FMOD_DSP_FFT_WINDOW_);
===
argument0 = REAL - A channel handle
argument1 = REAL - The total number of slot values (size of array)
argument2 = REAL - The channel offset (for example, stereo streams)
argument3 = REAL - The FFT window type  FMOD_DSP_FFT_WINDOW_
===
return = NULL
===
//Com:
      This works just like sxfmod_system_getSpectrum(), except you can get
      spectrum anaylsis via a single channel, rather than the entire output
      audio.
      
      Check sxfmod_system_getSpectrum() for more information.
*/
return external_call(sxms.dll_sxfmod_channel_getSpectrum,argument0,argument1,argument2,argument3);
#define sxfmod_channel_getMode
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getMode(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The modes for the channel, or -1 if failure.
===
//Com:
      Since multiple modes can be set to a single channel, you will have
      to check the return flags by using the bitwise 'AND' symbol.
      
      ex: if (sxfmod_channel_getMode(0) & FMOD_LOOP_OFF) { }
      
      That would check to see if the FMOD_LOOP_OFF flag was found.
*/
return external_call(sxms.dll_sxfmod_channel_getMode,argument0);
#define sxfmod_channel_setLoopCount
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setLoopCount(channel,loop);
===
argument0 = REAL - A channel handle
argument0 = REAL - The number of times the sound should loop.
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      You can set how many times a channel should loop before stopping by
      using this function.  This is the number of times it should loop.  So
      a 1 would make it loop once, while a setting of 0 would make it play
      and stop at end.  If you pass a -1, the sound will loop indefinately.
      (-1 is the default setting).
*/
return external_call(sxms.dll_sxfmod_channel_setLoopCount,argument0,argument1);
#define sxfmod_channel_getIndex
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getIndex(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The channel index assigned to this channel handle
===
//Com:
      Note, do not get this confused with a channel handle.  This mainly is
      for returning which software channel the audio is being played out
      of.  So example, if you initialized 32 channels and then you played
      a sound, this can be used to figure out which software channel
      the audio is outputing on.
*/
return external_call(sxms.dll_sxfmod_channel_getIndex,argument0);
#define sxfmod_channel_setMode
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setMode(channel,sxms.FMOD_);
===
argument0 = REAL - A channel handle
argument1 = REAL - The mode(s) to set:  FMOD_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This is used to set mode types to the specified channel.  You can
      send multiple at a time by using the | symbol.
*/
return external_call(sxms.dll_sxfmod_channel_setMode,argument0,argument1);
#define sxfmod_channel_setLoopPoints
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_setLoopPoints(channel,start,sxms.FMOD_TIMEUNIT_,end,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A channel handle
argument1 = REAL - The starting loop point
argument2 = REAL - The timeunit used for argument1:  FMOD_TIMEUNIT_
argument3 = REAL - The ending loop point
argument4 = REAL - The timeunit used for argument3:  FMOD_TIMEUNIT_
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      This can be used to set internal loop points to the channel.  Note that
      the very begining of audio is 0 while the end is always the length -1.
      
      Example, a 1000ms song's normal loop points are 0 and 999.
*/
return external_call(sxms.dll_sxfmod_channel_setLoopPoints,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_channel_getLoopPoints
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getLoopPoints(channel,returnType,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - A channel handle
argument1 = REAL - The type of information returned.
            0    - The starting loop point
            1    - The ending loop point
argument2 = REAL - The time method for the return:  FMOD_TIMEUNIT_
===
return = REAL - Depends on argument1, or -1 if failure.
===
//Com:
      This can be used to obtain the loop points for a channel.  Make sure to
      specify a time unit.
*/
return external_call(sxms.dll_sxfmod_channel_getLoopPoints,argument0,argument1,argument2);
#define sxfmod_channel_getLoopCount
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_getLoopCount(channel);
===
argument0 = REAL - A channel handle
===
return = REAL - The sound's loop count, or -2 if failure.
===
//Com:
      This returns the current loop count set to the sound.  Remember that
      -1 means indefinate (don't mistake a -1 as an error)
*/
return external_call(sxms.dll_sxfmod_channel_getLoopCount,argument0);
#define sxfmod_channel_set3DOcclusion
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channel_set3DOcclusion(channel,direct,reverb);
===
argument0 = REAL - A channel handle
argument1 = REAL - The direct occlusion
argument2 = REAL - The reverb occlusion
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Both valaes are from 0.0 to 1.0.
      
      Sets the EAX or software based occlusion factors for a channel.
*/
return external_call(sxms.dll_sxfmod_channel_set3DOcclusion,argument0,argument1,argument2);
#define sxfmod_memory_getStats
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_memory_getStats(returnType);
===
argument0 = REAL - The type of returned information (0-1)
            0    - Amount of allocated memory at time of call
            1    - Maximum allocated memory
===
return = REAL - Depends on arguments, -1 if failure.
===
//Com:
      This can be used to get the current memory reserved for FMOD.
      Passing a 0 gives you the current FMOD memory usage, while a 1
      gives you the maximum.
*/
return external_call(sxms.dll_sxfmod_memory_getStats,argument0);
#define sxfmod_getSpectrum
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_getSpectrum(slot);
===
argument0 = REAL - A value to pull from the visual array.
===
return = REAL - The percent of audio on the given slot, or -1 on failure.
===
//Com:
      Once you've filled the visual array in the DLL, you can pull the
      individual values using this function.  Just make sure that you don't
      try to pull from a non-existant slot.
      
      (Ex:  You fill a 64 slot array and then try to pull from slot 89)
      
      Check sxfmod_system_getSpectrum() for more information.
*/
return external_call(sxms.dll_sxfmod_getSpectrum,argument0);
#define sxfmod_channelGroup_release
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_release(group);
===
argument0 = REAL - A channel group handle
===
return = REAL - 1 Successful, or 0 if failure
===
//Com:
      Once you are done with a channel group, you can use this to remove
      it.  Once removed, the group handle cannot be used.  This also frees
      the related memory.
*/
return external_call(sxms.dll_sxfmod_channelGroup_release,argument0);
#define sxfmod_channelGroup_setVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_setVolume(group,vol);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The volume to set (0.0 to 1.0)
===
return = REAL - 1 Successful, or 0 if failure
===
//Com:
      This does not overwrite the individual channel volume settings.  It
      scales them according to the channel group's volume.
*/
return external_call(sxms.dll_sxfmod_channelGroup_setVolume,argument0,argument1);
#define sxfmod_channelGroup_getVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_getVolume(group);
===
argument0 = REAL - A channel group handle
===
return = REAL - The volume (0.0 to 1.0) or -1 if failure.
===
//Com:
      Gets the current volume setting for the channelGroup.
*/
return external_call(sxms.dll_sxfmod_channelGroup_getVolume,argument0);
#define sxfmod_channelGroup_setPitch
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_setPitch(group,pitch);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The pitch to set (0.0 to 10.0)
===
return = REAL - Successful (1) or Failed (0)
===
//Com:
      This does not overwrite individual channel frequencies.  It only scales
      them according to the channel group's pitch. 
*/
return external_call(sxms.dll_sxfmod_channelGroup_setPitch,argument0,argument1);
#define sxfmod_channelGroup_getPitch
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_getPitch(group);
===
argument0 = REAL - A channel group handle
===
return = REAL - The pitch (0.0 to 10.0) or -1 if failure
===
//Com:
      Returns the current pitch setting for the channel group.
*/
return external_call(sxms.dll_sxfmod_channelGroup_getPitch,argument0);
#define sxfmod_channelGroup_stop
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_stop(group);
===
argument0 = REAL - A channel group handle
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Stops all channels in the current channel group.
*/
return external_call(sxms.dll_sxfmod_channelGroup_stop,argument0);
#define sxfmod_channelGroup_overridePaused
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_overridePaused(group,pause);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The pause setting (0 or 1)
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the pause setting on all channels in the group.
*/
return external_call(sxms.dll_sxfmod_channelGroup_overridePaused,argument0,argument1);
#define sxfmod_channelGroup_overrideVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_overrideVolume(group,vol);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The volume setting (0.0 to 1.0)
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the volume setting on all channels in the group.
      This will modify the individual channel volume settings.  If you want
      a more "master volume" control, use sxfmod_channelGroup_setVolume() 
*/
return external_call(sxms.dll_sxfmod_channelGroup_overrideVolume,argument0,argument1);
#define sxfmod_channelGroup_overrideFrequency
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_overrideFrequency(group,freq);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The frequency setting.
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the frequency setting on all channels in the group.
      This will modify the individual channel frequency settings.  If you want
      a more "master frequency" control, use sxfmod_channelGroup_setPitch()
      
      You may use negative frequencies to have audio play backwards.
*/
return external_call(sxms.dll_sxfmod_channelGroup_overrideFrequency,argument0,argument1);
#define sxfmod_channelGroup_overridePan
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_overridePan(group,pan);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The pan setting. (-1.0 to 1.0)
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the pan setting on all channels in the group.
      Negative values are left, positive are right.
*/
return external_call(sxms.dll_sxfmod_channelGroup_overridePan,argument0,argument1);
#define sxfmod_channelGroup_overrideMute
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_overrideMute(group,mute);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The mute setting. (0 or 1)
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the mute setting on all channels in the group. 
*/
return external_call(sxms.dll_sxfmod_channelGroup_overrideMute,argument0,argument1);
#define sxfmod_channelGroup_override3DAttributes
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_override3DAttributes(group,vectorType,x,y,z);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The type of vector
            0    - A position
            1    - A velocity
argument2 = REAL - The X value of a vector
argument3 = REAL - The Y value of a vector
argument4 = REAL - The Z value of a vector 
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the 3D Attributes on all channels in the group. 
*/
return external_call(sxms.dll_sxfmod_channelGroup_override3DAttributes,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_channelGroup_overrideSpeakerMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_overrideSpeakerMix(group,frontLeft,frontRight,center,LFE,backLeft,backRight,sideLeft,sideRight);
===
argument0 = REAL - A channel group handle
argument1 = REAL - Front Left speaker level
argument2 = REAL - Front Right
argument3 = REAL - Center
argument4 = REAL - LFE
argument5 = REAL - Back Left
argument6 = REAL - Back Right
argument7 = REAL - Side Left
argument8 = REAL - Side Right
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Sets the SpeakerMix on all channels in the group.
      
      The value range for each argument is from 0.0 (silent) to 1.0 (full)
*/
return external_call(sxms.dll_sxfmod_channelGroup_overrideSpeakerMix,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8);
#define sxfmod_channelGroup_addGroup
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_addGroup(parentGroup,group);
===
argument0 = REAL - A channel group handle
argument1 = REAL - A channel group handle to add
===
return = REAL - Successful (1) of failed (0)
===
//Com:
      Allows you to put one channel group as a child of another.
      argument0 is the parent, argument1 is the child to be added.
      
      All settings placed on the parent group will effect the child group,
      but effects placed on the child will not effect the parent.
*/
return external_call(sxms.dll_sxfmod_channelGroup_addGroup,argument0,argument1);
#define sxfmod_channelGroup_getNumGroups
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_getNumGroups(group);
===
argument0 = REAL - A channel group handle
===
return = REAL - The number of child groups, or -1 if failure
===
//Com:
      This returns the number of child groups inside a parent group.
*/
return external_call(sxms.dll_sxfmod_channelGroup_getNumGroups,argument0);
#define sxfmod_channelGroup_addDSP
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_addDSP(group,DSPindex);
===
argument0 = REAL - A channel group handle
argument1 = REAL - A DSP handle to place onto the channel group
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      Use this function to attach a DSP onto a channel group.
*/
return external_call(sxms.dll_sxfmod_channelGroup_addDSP,argument0,argument1);
#define sxfmod_channelGroup_getNumChannels
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_getNumChannels(group);
===
argument0 = REAL - A channel group handle
===
return = REAL - The number of channels in the group, or -1 if failure
===
//Com:
      This returns the number of channels inside the group.
*/
return external_call(sxms.dll_sxfmod_channelGroup_getNumChannels,argument0);
#define sxfmod_channelGroup_getSpectrum
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_channelGroup_getSpectrum(group,size,channelOffset,sxms.FMOD_DSP_FFT_WINDOW_);
===
argument0 = REAL - A channel group handle
argument1 = REAL - The total number of slot values (size of array)
argument2 = REAL - The channel offset (for example, stereo streams)
argument3 = REAL - The FFT window type  FMOD_DSP_FFT_WINDOW_
===
return = NULL
===
//Com:
      This works just like sxfmod_system_getSpectrum(), except you can get
      spectrum anaylsis via a channel group, rather than the entire output
      audio.
      
      Check sxfmod_system_getSpectrum() for more information.
*/
return external_call(sxms.dll_sxfmod_channelGroup_getSpectrum,argument0,argument1,argument2,argument3);
#define sxfmod_dsp_release
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_release(dsp);
===
argument0 = REAL - A DSP index handle
===
return = Whether successful (1) or failure (0)
===
//Com:
      Use this function to release (delete) a DSP.  It is recommended that
      you detach (or are not using) the DSP before releasing.  This will
      automatically clean up the used memory.
*/
return external_call(sxms.dll_sxfmod_dsp_release,argument0);
#define sxfmod_dsp_remove
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_remove(dsp);
===
argument0 = REAL - A DSP index handle
===
return = Whether successful (1) or failure (0)
===
//Com:
      Call this to remove the attached DSP from the system or channel.
      
      If you used channel_addDSP or system_addDSP, then this is the function
      you would use to remove it.
      
      Note, this does NOT delete/clear the DSP, use sxfmod_dsp_release()
      for that.
*/
return external_call(sxms.dll_sxfmod_dsp_remove,argument0);
#define sxfmod_dsp_getNumInputs
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getNumInputs(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - The number of inputs or -1 if failure
===
//Com:
      Returns the number of inputs currently associated to the DSP.
      
      This should be used before using the other DSP functions which require
      a DSP input number. 
*/
return external_call(sxms.dll_sxfmod_dsp_getNumInputs,argument0);
#define sxfmod_dsp_getNumOutputs
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getNumOutputs(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - The number of outputs or -1 if failure
===
//Com:
      Returns the number of outputs currently associated to the DSP. 
*/
return external_call(sxms.dll_sxfmod_dsp_getNumOutputs,argument0);
#define sxfmod_dsp_setInputMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_setInputMix(dsp,input,vol);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The input number to set volume for
argument2 = REAL - The volume amount (0.0 to 1.0)
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      Used to set the volume of the specified input for the selected DSP.
*/
return external_call(sxms.dll_sxfmod_dsp_setInputMix,argument0,argument1,argument2);
#define sxfmod_dsp_getInputMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getInputMix(dsp,input);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The input number to get volume of
===
return = REAL - The volume amount or -1 if failure
===
//Com:
      Gets the volume setting for the indicated input.  The value range is
      from 0.0 (silent) to 1.0 (full)
*/
return external_call(sxms.dll_sxfmod_dsp_getInputMix,argument0,argument1);
#define sxfmod_dsp_setOuputMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_setOutputMix(dsp,output,vol);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The output number to set volume for
argument2 = REAL - The volume amount (0.0 to 1.0)
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      Used to set the volume of the specified output for the selected DSP.
*/
return external_call(sxms.dll_sxfmod_dsp_setOutputMix,argument0,argument1,argument2);
#define sxfmod_dsp_getOutputMix
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getOutputMix(dsp,output);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The output number to get volume of
===
return = REAL - The volume amount or -1 if failure
===
//Com:
      Gets the volume setting for the indicated output.  The value range is
      from 0.0 (silent) to 1.0 (full)
*/
return external_call(sxms.dll_sxfmod_dsp_getOutputMix,argument0,argument1);
#define sxfmod_dsp_setActive
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_setActive(dsp,active);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The Active setting (0 or 1)
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      This function is used to set the active state of a DSP.
      
      When you attach a DSP to a channel or system, it doesn't initially start
      active (or the channel/system will play as if it's turned off) so make
      sure to activate.
      
      If you need to deactivate a DSP (without actually having to remove it)
      then you can use this function as well. 
*/
return external_call(sxms.dll_sxfmod_dsp_setActive,argument0,argument1);
#define sxfmod_dsp_getActive
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getActive(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - Whether active (1) or not (0), -1 if error
===
//Com:
      This function returns the current active state of the DSP. 
*/
return external_call(sxms.dll_sxfmod_dsp_getActive,argument0);
#define sxfmod_dsp_setBypass
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_setBypass(dsp,bypass);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The bypass setting (0 or 1)
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      This function sets the bypass setting for the DSP.
      
      This is used to toggle whether the DSP should process the data coming
      into it or not.  The audio data will still go thru the DSP, but will
      not show any changes by the DSP.
*/
return external_call(sxms.dll_sxfmod_dsp_setBypass,argument0,argument1);
#define sxfmod_dsp_getBypass
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getBypass(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - Whether bypass is enabled (1) or not (0), -1 if error
===
//Com:
       This function returns the bypass setting on a DSP. 
*/
return external_call(sxms.dll_sxfmod_dsp_getBypass,argument0);
#define sxfmod_dsp_reset
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_reset(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
       Used to clear the DSP's internal buffers and return the DSP back to
       it's "initial" state. 
*/
return external_call(sxms.dll_sxfmod_dsp_reset,argument0);
#define sxfmod_dsp_setParameter
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_setParameter(dsp,parameter,value);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - A Parameter index to adjust
argument2 = REAL - The value to set for the parameter
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
       This function is used to change set parameters of a DSP.  Use
       sxfmod_dsp_getNumParameters() to get the number avaliable, and use
       sxfmod_dsp_getParameterInfo() for more information on what each
       parameter does.
       
       The value range for argument2 depends on the parameter being adjusted.
*/
return external_call(sxms.dll_sxfmod_dsp_setParameter,argument0,argument1,argument2);
#define sxfmod_dsp_getParameter
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getParameter(dsp,parameter);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - A Parameter index to pull from
===
return = REAL - The value from the indicated parameter
===
//Com:
       Used to get the value of the specified parameter. 
*/
return external_call(sxms.dll_sxfmod_dsp_getParameter,argument0,argument1);
#define sxfmod_dsp_getNumParameters
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getNumParameters(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - The number of avaliable parameters, or -1 if failure
===
//Com:
       This should be used before the other parameter functions.  This is used
       to get the total number of parameters avaliable.
*/
return external_call(sxms.dll_sxfmod_dsp_getNumParameters,argument0);
#define sxfmod_dsp_getParameterInfo
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getParameterInfo(dsp,parameter,returnType);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - A parameter index number
argument2 = REAL - The type of information to return (0 to 4)
===
return = STRING - Depends on argument2, "" on error
===
//Com:
      This function is used to get various information about a parameter.
      
      argument2 is used to determine what information to return.  The
      following types of data can be returned:
      
      0 - Name of the parameter
      1 - The parameter's Label
      2 - A short discription of the parameter
      3 - (REAL) the mininum value which can be set to the parameter
      4 - (REAL) the maximum value which can be set to the parameter
      
      For 3 and 4, these are numbers in the form of a string.
      
      Remember that the type of parameters avaliable are determined by the
      type of DSP in use (so parameter 0 for one DSP won't be the same as
      another in most cases). 
*/
return external_call(sxms.dll_sxfmod_dsp_getParameterInfo,argument0,argument1,argument2);
#define sxfmod_dsp_showConfigDialog
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_showConfigDialog(dsp,embed);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - Whether to show in the GM window (1) or not (0)
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      Some DSP's include a GUI which can be used to edit settings.  Note the
      key word here as "some".  Not all DSP's have a dialog and it should
      not be assumed one is available. 
*/
return external_call(sxms.dll_sxfmod_dsp_showConfigDialog,argument0,argument1);
#define sxfmod_dsp_getInfo
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getInfo(dps,returnType);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - The type of information to return (0 to 4)
===
return = STRING - Depends on argument1, "" if error.
===
//Com:
      This can be used to get more general information about the DSP Unit.
      
      Various types of information can be return, which are outlined here:
      0 - Name of the DSP
      1 - (REAL) Version of the DSP
      2 - (REAL) The number of channels the DSP can work with
      3 - (REAL) Configuration Dialog's width (pixels)
      4 - (REAL) Configuration Dialog's height (pixels) 
*/
return external_call(sxms.dll_sxfmod_dsp_getInfo,argument0,argument1);
#define sxfmod_dsp_getType
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getType(dsp);
===
argument0 = REAL - A DSP index handle
===
return = REAL - A FMOD_DSP_TYPE_
===
//Com:
      This can be used to get the type of DSP unit
*/
return external_call(sxms.dll_sxfmod_dsp_getType,argument0);
#define sxfmod_dsp_setDefaults
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_setDefaults(dsp,freq,vol,pan,priority);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - Frequency
argument2 = REAL - Volume (0.0 to 1.0)
argument3 = REAL - Panning (-1.0 to 1.0)
argument4 = REAL - Priority (0 to 255)
===
return = REAL - Whether successful (1) or failure (0)
===
//Com:
      This is used to set "default" settings to a DSP.  These include
      frequency, volume, panning and priority.  Mainly used if your DSP
      is generating it's own sound.
*/
return external_call(sxms.dll_sxfmod_dsp_setDefaults,argument0,argument1,argument2,argument3,argument4);
#define sxfmod_dsp_getDefaults
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxfmod_dsp_getDefaults(dsp,returnType);
===
argument0 = REAL - A DSP index handle
argument1 = REAL - Type of information to return (0 to 3)
===
return = REAL - Depends on argument1, -1 on error
===
//Com:
      Returns information about default settings on a DSP.  The information
      returned depends on argument1.
      0 - Frequency
      1 - Volume
      2 - Panning
      3 - Priority
*/
return external_call(sxms.dll_sxfmod_dsp_getDefaults,argument0,argument1);
#define sxwamp_init
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_init();
===
No Arguments
===
return = NULL
===
//Com:
      This is used to initialize the winamp support.
*/
return external_call(sxms.dll_sxwamp_init);
#define sxwamp_input_remove
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_input_remove();
===
No Arguments
===
return = NULL
===
//Com:
      Use this to remove the current input plugin
*/
return external_call(sxms.dll_sxwamp_input_remove);
#define sxwamp_output_remove
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_output_remove();
===
No Arguments
===
return = NULL
===
//Com:
      Use this to remove the current output plugin
*/
return external_call(sxms.dll_sxwamp_output_remove);
#define sxwamp_close
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_close();
===
No Arguments
===
return = NULL
===
//Com:
      This closes down the winamp support
*/
return external_call(sxms.dll_sxwamp_close);
#define sxwamp_input_load
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_input_load(filename);
===
argument0 = STRING - The filepath and name of a winamp input plugin
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to load an input plugin.
      
      Note:  You must load an output plugin before loading an input plugin.
      This is because the input plugin needs to set settings to the output
      plugin.  Otherwise, "An Unexpected Error" will occur.
*/
return external_call(sxms.dll_sxwamp_input_load,argument0);
#define sxwamp_output_load
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_output_load(filename);
===
argument0 = STRING - The filepath and name of a winamp output plugin
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Use this to load an output plugin.  This should be done before loading
      an input plugin.
*/
return external_call(sxms.dll_sxwamp_output_load,argument0);
#define sxwamp_stop
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_stop();
===
No Arguments
===
return = NULL
===
//Com:
      Stops all current playback.
*/
return external_call(sxms.dll_sxwamp_stop);
#define sxwamp_play
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_play(filename);
===
argument0 = STRING - The filepath and name of a file to play
===
return = REAL - Whether successful (1) or failed (0)
===
//Com:
      Plays the specified file.  You may pass "dialog" for the function
      to automatically pull up an "open filename" dialog.
      
      Make sure the output and input plugin have been loaded before playing
      any audio.  Also, make sure the input plugin supports the specified
      file format.
*/
if (argument0 = "dialog") { argument0 = get_open_filename("All Files|*.*",""); };
if (!file_exists(argument0) or argument0 = "") { return 0; };
return external_call(sxms.dll_sxwamp_play,argument0);
#define sxwamp_isPlaying
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_isPlaying();
===
No Arguments
===
return = REAL - Whether currently playing (1) or not (0).
===
//Com:
      Tells whether a song is currently playing or not.
      
      This can be a bit buggy depending on the input plugin.
*/
return external_call(sxms.dll_sxwamp_isPlaying);
#define sxwamp_setPaused
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_setPaused(pause);
===
argument0 = REAL - Whether to pause (1) or unpause (0).
===
return = NULL
===
//Com:
      Allows you to pause or unpause the currently playing audio.
*/
return external_call(sxms.dll_sxwamp_setPaused,argument0);
#define sxwamp_getPaused
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getPaused();
===
No Arguments
===
return = REAL - Whether paused (1) or not (0)
===
//Com:
      Whether the audio is paused or not.
*/
return external_call(sxms.dll_sxwamp_getPaused);
#define sxwamp_getLength
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getLength();
===
No Arguments
===
return = REAL - The length of the current song.
===
//Com:
      The unit of the length depends on the input plugin.  Most of the time
      this is in milliseconds, but not always.
*/
return external_call(sxms.dll_sxwamp_getLength);
#define sxwamp_getTime
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getTime();
===
No Arguments
===
return = REAL - The current position of the song.
===
//Com:
      The unit of the position depends on the input plugin.  Most of the time
      this is in milliseconds, but not always.
*/
return external_call(sxms.dll_sxwamp_getTime);
#define sxwamp_setTime
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_setTime(milliseconds);
===
argument0 = REAL - The position to set the current song.
===
return = NULL
===
//Com:
      Lets you set the position of a song.  Some input plugins don't support
      this feature fully.  Also, the unit is usually milliseconds, but not
      always (depending on plugin).
*/
return external_call(sxms.dll_sxwamp_setTime,argument0);
#define sxwamp_setVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_setVolume(vol);
===
argument0 = REAL - The volume of a song (0 - 255)
===
return = NULL
===
//Com:
      Allows you to set the current volume.  0 is mute while 255 is full.
*/
return external_call(sxms.dll_sxwamp_setVolume,argument0);
#define sxwamp_getVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getVolume();
===
No Arguments
===
return = The current volume setting (0 - 255)
===
//Com:
      Returns the current volume setting.  0 is mute while 255 is full
*/
return external_call(sxms.dll_sxwamp_getVolume);
#define sxwamp_setPan
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_setPan(pan);
===
argument0 = REAL - The pan setting for the current audio. (-127 to 127)
===
return = NULL
===
//Com:
      Allows you to set the panning.  -127 is full left while 127 is full right
*/
return external_call(sxms.dll_sxwamp_setPan,argument0);
#define sxwamp_getConfigure
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getConfigure(plugin);
===
argument0 = REAL - Whether to get input or output plugin configure
            0    - Input
            1    - Output
===
return = NULL
===
//Com:
      Brings up the plugins configure dialog.  Some plugins don't include
      much (if any) configuration setup.
*/
return external_call(sxms.dll_sxwamp_getConfigure,argument0);
#define sxwamp_getAbout
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getAbout(plugin);
===
argument0 = REAL - Whether to get input or output plugin about
            0    - Input
            1    - Output
===
return = NULL
===
//Com:
      Brings up the plugins about dialog.  Some plugins might not include
      an about dialog.
*/
return external_call(sxms.dll_sxwamp_getAbout,argument0);
#define sxwamp_getExtentions
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxwamp_getExtentions();
===
No Arguments
===
return = STRING - Returns the plugin's acceptable extentions
===
//Com:
      (Experimental):  This function is still in testing and might not
      work for some plugins (if any).
      
      It returns the current input plugin's allowable file extentions.
      (or, the file formats the input plugin can play).
*/
return external_call(sxms.dll_sxwamp_getExtentions);
#define sxeasy_init
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_init(channels);
===
argument0 = REAL - The total number of software channels
===
return = REAL - 1 if successful, 0 if failure
*/

//sxfmod_system_create()
if (!external_call(sxms.dll_sxfmod_system_create)) { return 0; };
//sxfmod_system_setOutput()
if (!external_call(sxms.dll_sxfmod_system_setOutput,sxms.FMOD_OUTPUTTYPE_WINMM)) { return 0; };
//sxfmod_system_init()
if (!external_call(sxms.dll_sxfmod_system_init,argument0,sxms.FMOD_INIT_NORMAL,0)) { return 0; };
sxms.easyPlay = 0;
sxms.easyChannel = -1;
return 1;
#define sxeasy_play
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_play(filename,sxms.FMOD_,channel);
===
argument0 = STRING - Filename of file to play
argument1 = REAL - additional flags:  sxms.FMOD_
argument2 = REAL - Channel to play on (or sxms.FMOD_CHANNEL_FREE for any)
===
return = REAL - Successful (1) or failure (0);
===
// Com:
       For argument0, you can pass the string "dialog" for a dialog box to
       display.
       
       Argument1 already has a few flags by default.  The only flag you
       could add is sxms.FMOD_ACCURATETIME or sxms.FMOD_LOOP_
       
       Argument2 is the channel you want to play on.  Usually this is either
       0 or sxms.FMOD_CHANNEL_FREE.
*/

if (argument0 = "dialog") { argument0 = get_open_filename("All Files|*.*",""); };
if (string_pos("http:",argument0) != 1) {
   if (!file_exists(argument0) or argument0 = "") { return 0; };
};
if (sxms.easyPlay) { sxeasy_stop(); };
//sxfmod_system_createSound()
if (!external_call(sxms.dll_sxfmod_system_createSound,argument0,(argument1|sxms.SXMS_MUSIC),0,0)) { return -1; };
//sxfmod_system_playSound()
sxms.easyChannel = external_call(sxms.dll_sxfmod_system_playSound,0,0,argument2);
sxms.easyPlay = 1;
sxms.easyFile = argument0;
return 1;
#define sxeasy_stop
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_stop();
===
No Arguments
===
return = REAL - Successful (1) or failure (0)
===
// Com:
       Stops the currently playing audio
*/

if (!sxms.easyPlay) { return 0; };
//sxfmod_channel_stop()
external_call(sxms.dll_sxfmod_channel_stop,sxms.easyChannel);
//sxfmod_sound_release()
external_call(sxms.dll_sxfmod_sound_release,0);
sxms.easyPlay = 0;
sxms.easyChannel = -1;
return 1;
#define sxeasy_setVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_setVolume(vol);
===
argument0 = REAL - The volume (0.0 to 1.0)
===
return = REAL - Successful (1) or failure (0);
*/

if (!sxms.easyPlay) { return 0; };
//sxfmod_channel_setVolume()
return external_call(sxms.dll_sxfmod_channel_setVolume,sxms.easyChannel,argument0);
#define sxeasy_close
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_close();
===
No Arguments
===
return = REAL - Successful (1) or failure (0)
===
// Com:
       Closes down sxms
*/

sxeasy_stop();
//sxfmod_system_release()
return external_call(sxms.dll_sxfmod_system_release);
#define sxeasy_getVolume
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_getVolume();
===
No Arguments
===
return = REAL - The current volume setting
*/

if (!sxms.easyPlay) { return 0; };
//sxfmod_channel_getVolume()
return external_call(sxms.dll_sxfmod_channel_getVolume,sxms.easyChannel);
#define sxeasy_setPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_setPosition(position,sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - Position to set sound
argument1 = REAL - The type of time unit:  FMOD_TIMEUNIT_
===
return = REAL - Successful (1) or failure (0)
*/

if (!sxms.easyPlay) { return 0; };
//sxfmod_channel_setPosition()
return external_call(sxms.dll_sxfmod_channel_setPosition,sxms.easyChannel,argument0,argument1);
#define sxeasy_getPosition
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for Game Maker
--Brandon Rohrer  2003-2006
============================================
sxeasy_getPosition(sxms.FMOD_TIMEUNIT_);
===
argument0 = REAL - The type of time unit:  FMOD_TIMEUNIT_
===
return = REAL - The current position
*/

if (!sxms.easyPlay) { return 0; };
//sxfmod_channel_getPosition()
return external_call(sxms.dll_sxfmod_channel_getPosition,sxms.easyChannel,argument0);
#define sxms_ReadMe
/*Shaltif's Xtreme Music and Sound
--The Fmod / WinAmp Wrapper for GAME MAKER
--Brandon Rohrer  2003-2006
--Version 3.0.6.2 Beta
============================================
FMOD Sound System copyright  Firelight Technologies Pty, Ltd., 1994-2006
---Fmod plugins copyrighted by their respective owners

Winamp  1997-2006 Nullsoft, Inc
---Winamp plugins copyrighted by their respective owners
---Original C/C++ PlugWrap Source by Mic

GAME MAKER is Copyright 2000-2006 The Game Maker Company B.V.; All rights reserved.

//MINIMUM REQUIREMENTS//
GAME MAKER 6.x (Registered)
DirectX 8.1 or better (Latest Version recommended)
A Decent Soundcard

***Before using FMOD, please read over the FMOD license agreement***

//TERMS OF USE//
By downloading and using SXMS, you agree to be bound by the following terms.

1. You, "The User", claim full responsibility for any and all damages that
   may occur while using SXMS.
   
2. I, "The Author", do NOT give any warranty or guarantee that SXMS will
   work without flaw on any computer system.

3. You are NOT allowed to decompile, reverse engineer, modify, alter or do
   any other similar acts with the SXMS.dll.

4. You may NOT sell SXMS, any of the contained files from the Zip Package,
   and/or the Zip Package itself.

5. You may use SXMS in any FREEWARE application or project.  However, if
   your project is SHAREWARE or COMMERCIAL, you MUST contact me first.

6. If using the FMOD side of SXMS, you are bound by FMOD's license agreement.
   ( This license can be found at http://www.fmod.org )

//INSTALLATION//
To use SXMS in your project, you will need to do the following:

1. Import the supplied SXMS scripts
2. Make a "dummy" object called sxms (make sure it's all lowercase)
3. Move the SXMS-3.dll into the working directory of your program.
3a. Also move FMOD's DLL and/or any Winamp's DLLs
(Make sure these stay with your program)

You can then use SXMS as you like.  All scripts contain internal comments
about their use.  Also, make sure to read the SXMS Help document.  You
can even use the Fmod's help document for reference on the more technical
issues, since this wrapper is as "transparent" as possible to using
Fmod directly.

//CONTACTING//
You may contact me by using GAME MAKER's forum PM system.
My contact name is Shaltif.
*/
return 0;
