#define HTTP_Connect
/*
*   Autor: Ranma_man
*   http://gmclan.prv.pl
*
* --------------------------------------
*
*   HTTP_Connect - Polaczenie z serwerem http.
*   Argument0    - Adres www. Podajemy bez http://
*   Zwraca       - Identyfikator polaczenia (0 w przypadku braku polaczenia).
*/

var HTTPCid;

HTTPCid = sock_lookup( argument0 );

if ( HTTPCid != "" )
    return sock_connect( sock_lookup( argument0 ), 80, 1 );
else
    return 0;
#define HTTP_Connect_IP
/*
*   Autor: Ranma_man
*   http://gmclan.prv.pl
*
* --------------------------------------
*
*   HTTP_Connect - Polaczenie z serwerem http.
*                - Jest to funkcja do laczenia za pomoca IP serwera.
*   Argument0    - tekst z numerem IP np: "192.168.10.1"
*   Zwraca       - Identyfikator polaczenia (0 w przypadku braku polaczenia).
*/


return sock_connect( argument0 , 80, 1 );
#define HTTP_Send
/*
*   Autor: Ranma_man
*   http://gmclan.prv.pl
*
* --------------------------------------
*
*   HTTP_Send    - Wysylanie danych.
*   Argument0    - Identyfikator polaczenia
*   Argument1    - User Agent. Informacje dotyczace programu-przegladarki.
*   Argument2    - Sciezka katalogu/pliku itd. Musi sie zaczynac od slasha /
                 - Gdy podajemy to poczatek musi zaczynac sie od http://
*   Zwraca       - Liczbe wyslanych znakow
*/

return sock_send( argument0, "GET "+argument2+" HTTP/1.0
User-Agent: "+argument1+"

");
#define HTTP_Receive
/*
*   Autor: Ranma_man
*   http://gmclan.prv.pl
*
* --------------------------------------
*
*   HTTP_Receive - Odbiera tekst ( odpowiedz z serwera ) po wyslaniu informacji za pomoca HTTP_Send
*   Argument0    - Identyfikator polaczenia
*   Argument1    - Liczba znakow do pobrania za jednym zamachem, -1 oznacza pobranie wszystkich znakow na raz..
*   Zwraca       - Ciag znakow odczytanych z portu 80 ( protokol http )
*/

var SR, SC, ST;

SC = "";
SR = "";
ST = 0;

while ( true )
{
    SC = sock_receive ( argument0 );
    if ( SC != "" )
        SR += SC;
    else
        break;
    ST += 1;
    if ( argument1 > 0 )
        if ( ST == argument1 )
            break;
}

return SR;
#define HTTP_ClearBody
/*
*   Autor: Ranma_man
*   http://gmclan.prv.pl
*
* --------------------------------------
*
*   HTTP_Send    - Czysci tekst z naglowka.
*   Argument0    - Tekst.
*   Zwraca       - Tekst Wyczyszczony z naglowka oraz nowych linii na poczatku.
*/

var HTTPp, HTTPord;

HTTPp = string_pos( "

", argument0 );

argument0 = string_delete(argument0,1,HTTPp);

while ( true )
{
    HTTPord = ord(string_char_at( argument0, 1 ));
    if ( HTTPord == 10 || HTTPord == 13 )
        argument0 = string_delete( argument0, 1, 1 );
    else
        break;
}

return argument0;
#define HTTP_GetVars
/*
*   Autor: Ranma_man
*   http://gmclan.prv.pl
*
* --------------------------------------
*
*   HTTP_GetVars - Pobiera zmienne razem z ich nazwami.
*   Argument0    - Tekst, z ktorego beda pobrane zmienne.
*   Zwraca       - Identyfikator struktury "map",w ktorej zostaly zapisane zmienne
*                - ( Wiecej info o "map" helpie -> GML -> data structures )
*                - Map jest to taka rozbudowana tablica, ktora zapamietuje nazwy zmiennych
*
*   Zmienne musza zostac zapisane w formacie:
*   {nazwa zmiennej[wartosc zmienne]}
*
*   Jest to forma konieczna by odczyt sie powiodl. Nie stosowac egzotycznych znakow.
*/

var HTTPvars, HTTPlt, HTTPchar, HTTPkey, HTTPval;

HTTPvars = ds_map_create();

while ( true )
{
    HTTPlt = string_pos( '{', argument0 );

    if ( HTTPlt > 0 )
    {
        HTTPkey = "";
        HTTPval = "";

        while ( true )
        {
            HTTPlt += 1;
            HTTPchar = string_char_at( argument0 , HTTPlt );
            if ( HTTPchar != '[' )
                HTTPkey += HTTPchar;
            else
                break;
        }

        while ( true )
        {
            HTTPlt += 1;
            HTTPchar = string_char_at( argument0 , HTTPlt );
            if ( HTTPchar != ']' )
                HTTPval += HTTPchar;
            else
                break;
        }
        ds_map_add( HTTPvars, HTTPkey, HTTPval );
        argument0 = string_delete( argument0, 1, HTTPlt + 1 );
    }
    else
        break;
}

return HTTPvars;
