#define saud_Init
path="saudio.dll";
global.Load=external_define(path,"open",dll_stdcall,ty_real,2,ty_string,ty_string);
global.Play=external_define(path,"play",dll_stdcall,ty_real,1,ty_string);
global.Loop=external_define(path,"loop",dll_stdcall,ty_real,1,ty_string);
global.Stop=external_define(path,"stop",dll_stdcall,ty_real,1,ty_string);
global.StopAll=external_define(path,"stop_all",dll_stdcall,ty_real,0);
global.Pause=external_define(path,"pause",dll_stdcall,ty_real,1,ty_string);
global.Resume=external_define(path,"resume",dll_stdcall,ty_real,1,ty_string);
global.Position=external_define(path,"position",dll_stdcall,ty_string,1,ty_string);
global.Length=external_define(path,"length",dll_stdcall,ty_string,1,ty_string);
global.Seek=external_define(path,"seek",dll_stdcall,ty_real,2,ty_string,ty_string);
global.Status=external_define(path,"status",dll_stdcall,ty_string,1,ty_string);
global.Channels=external_define(path,"channels",dll_stdcall,ty_string,1,ty_string);
global.BytesPerSec=external_define(path,"bytespersec",dll_stdcall,ty_string,1,ty_string);
global.CanPlay=external_define(path,"canplay",dll_stdcall,ty_string,1,ty_string);
global.OpenRecord=external_define(path,"open_record",dll_stdcall,ty_real,1,ty_string);
global.Record=external_define(path,"record",dll_stdcall,ty_real,1,ty_string);
global.SaveRecord=external_define(path,"save_record",dll_stdcall,ty_real,2,ty_string,ty_string);
global.Close=external_define(path,"close",dll_stdcall,ty_real,1,ty_string);
global.CloseAll=external_define(path,"close_all",dll_stdcall,ty_real,0);
#define saud_Load
// Loads a file (mp3, wav, mid, avi) into memory
// Arg 0 = Path to the file (full path, use working_directory function
// if loading a file in same folder as the game)
// Arg 1 = The id to assign to the loaded file. Must be used to play, pause,
// ect. the file. (Ex: sound1, sound2, reload_sound, shoot_sound, ect.)

return external_call(global.Load,argument0,argument1);
#define saud_Play
// Plays a file
// Arg 0 = The id of the file.

return external_call(global.Play,argument0);
#define saud_Loop
// Loops a file
// Arg 0 = The id of the file.

return external_call(global.Loop,argument0);
#define saud_Stop
// Stops a file
// Arg 0 = The id of the file.

return external_call(global.Stop,argument0);
#define saud_StopAll
// Stops all files from playing

return external_call(global.StopAll);
#define saud_Pause
// Pauses a file
// Arg 0 = The id of the file.

return external_call(global.Pause,argument0);
#define saud_Resume
// Resumes a paused file
// Arg 0 = The id of the file.

return external_call(global.Resume,argument0);
#define saud_Position
// Current position in the file
// Arg 0 = The id of the file.

return real(external_call(global.Position,argument0));
#define saud_Length
// Length of the file
// Arg 0 = The id of the file.

return real(external_call(global.Length,argument0));
#define saud_Seek
// Seeks to a position in a file
// Arg 0 = The position to seek to.
// Arg 1 = The id of the file.

return external_call(global.Seek,""+string(argument0),argument1);
#define saud_Status
// Returns the status of the file
// Arg 0 = The id of the file.

return external_call(global.Status,argument0);
#define saud_Channels
// Returns how many channels does the file has (1=mono, 2=stereo)
// Arg 0 = The id of the file.

return real(external_call(global.Channels,argument0));
#define saud_BytesPerSec
// Returns how many bytes per second the file was recoreded at (44100=cd quality)
// Arg 0 = The id of the file.

return real(external_call(global.BytesPerSec,argument0));
#define saud_CanPlay
// Returns if the file can be played (is compatible)
// Arg 0 = The id of the file.

return external_call(global.CanPlay,argument0);
#define saud_LoadRecord
// Opens a new id in record mode, it's compatible with record features
// not to mention features like saud_Stop (stops recording), ect.
// Arg 0 = The id of the file.

return external_call(global.OpenRecord,argument0);
#define saud_Record
// Starts recording (think of it like play but only for recording)
// Arg 0 = The id of the file.

return external_call(global.Record,argument0);
#define saud_SaveRecord
// Saves a recording file to a wav
// Arg 0 = The path where the file should be saved (Ex: record.wav).
// Arg 1 = The id of the file.

return external_call(global.SaveRecord,argument0,argument1);
#define saud_Close
// Closes a file. Once the file is closed it cannot be played, paused, ect.
// Make sure that all opened files are closed when the game ends!
// Arg 0 = The id of the file.

return external_call(global.Close,argument0);
#define saud_CloseAll
// Closes all files. Call this when the game ends to be safe.

return external_call(global.CloseAll);
